/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.job;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.xmx.velthoric.init.VxMainClass;

public final class VxTerrainJobSystem {
    private final ExecutorService executorService;

    public VxTerrainJobSystem() {
        int threadCount = Math.max(3, Math.min(8, Runtime.getRuntime().availableProcessors() - 1));
        this.executorService = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new JobThreadFactory());
    }

    public CompletableFuture<Void> submit(Runnable task) {
        if (this.isShutdown()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(task, this.executorService);
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    VxMainClass.LOGGER.error("Terrain JobSystem did not terminate.");
                }
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public Executor getExecutor() {
        return this.executorService;
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown() || this.executorService.isTerminated();
    }

    private static class JobThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "Velthoric Terrain Job - ";

        private JobThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Velthoric Terrain Job - " + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

