/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.management;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.enumerate.EActivation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.xmx.velthoric.physics.terrain.VxUpdateContext;
import net.xmx.velthoric.physics.terrain.data.VxChunkDataStore;
import net.xmx.velthoric.physics.terrain.data.VxSectionPos;
import net.xmx.velthoric.physics.terrain.generation.VxTerrainShapeGenerator;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.NotNull;

public class VxTerrainManager {
    private final VxPhysicsWorld physicsWorld;
    private final class_3218 level;
    private final VxChunkDataStore chunkDataStore;
    private final VxTerrainShapeGenerator shapeGenerator;
    private final Set<VxSectionPos> chunksToRebuild = ConcurrentHashMap.newKeySet();
    private static final ThreadLocal<VxUpdateContext> updateContext = ThreadLocal.withInitial(VxUpdateContext::new);

    public VxTerrainManager(VxPhysicsWorld physicsWorld, class_3218 level, VxChunkDataStore chunkDataStore, VxTerrainShapeGenerator shapeGenerator) {
        this.physicsWorld = physicsWorld;
        this.level = level;
        this.chunkDataStore = chunkDataStore;
        this.shapeGenerator = shapeGenerator;
    }

    public void processRebuildQueue() {
        if (this.chunksToRebuild.isEmpty()) {
            return;
        }
        HashSet<VxSectionPos> batch = new HashSet<VxSectionPos>(this.chunksToRebuild);
        this.chunksToRebuild.removeAll(batch);
        for (VxSectionPos pos : batch) {
            Integer index = this.chunkDataStore.getIndexForPos(pos);
            if (index == null) continue;
            this.shapeGenerator.scheduleShapeGeneration(pos, index);
        }
    }

    public void onBlockUpdate(class_2338 worldPos) {
        VxSectionPos pos = VxSectionPos.fromBlockPos(worldPos.method_10062());
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index == null) {
            return;
        }
        int currentState = this.chunkDataStore.states[index];
        if (currentState == 4 || currentState == 3 || currentState == 6) {
            this.chunksToRebuild.add(pos);
        }
        this.physicsWorld.execute(() -> {
            BodyInterface bi = this.physicsWorld.getBodyInterface();
            if (bi == null) {
                return;
            }
            VxUpdateContext ctx = updateContext.get();
            ctx.vec3_1.set((float)worldPos.method_10263() - 2.0f, (float)worldPos.method_10264() - 2.0f, (float)worldPos.method_10260() - 2.0f);
            ctx.vec3_2.set((float)worldPos.method_10263() + 3.0f, (float)worldPos.method_10264() + 3.0f, (float)worldPos.method_10260() + 3.0f);
            ctx.aabox_1.setMin(ctx.vec3_1);
            ctx.aabox_1.setMax(ctx.vec3_2);
            bi.activateBodiesInAaBox(ctx.aabox_1, ctx.bplFilter, ctx.olFilter);
        });
    }

    public void onChunkLoadedFromVanilla(@NotNull class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        for (int y = this.level.method_32891(); y < this.level.method_31597(); ++y) {
            VxSectionPos vPos = new VxSectionPos(chunkPos.field_9181, y, chunkPos.field_9180);
            Integer index = this.chunkDataStore.getIndexForPos(vPos);
            if (index == null || this.chunkDataStore.referenceCounts[index] <= 0) continue;
            this.shapeGenerator.scheduleShapeGeneration(vPos, index);
        }
    }

    public void onChunkUnloaded(@NotNull class_1923 chunkPos) {
        for (int y = this.level.method_32891(); y < this.level.method_31597(); ++y) {
            this.unloadChunkPhysicsInternal(new VxSectionPos(chunkPos.field_9181, y, chunkPos.field_9180));
        }
    }

    public void activateChunk(int index) {
        if (this.chunkDataStore.states[index] == 6) {
            return;
        }
        if (this.chunkDataStore.bodyIds[index] != 0 && this.chunkDataStore.states[index] == 3) {
            this.chunkDataStore.states[index] = 4;
            this.physicsWorld.execute(() -> {
                BodyInterface bodyInterface = this.physicsWorld.getBodyInterface();
                int bodyId = this.chunkDataStore.bodyIds[index];
                if (bodyInterface != null && bodyId != 0 && !bodyInterface.isAdded(bodyId)) {
                    bodyInterface.addBody(bodyId, EActivation.Activate);
                }
            });
        }
    }

    public void deactivateChunk(int index) {
        if (this.chunkDataStore.bodyIds[index] != 0 && this.chunkDataStore.states[index] == 4) {
            this.chunkDataStore.states[index] = 3;
            this.physicsWorld.execute(() -> {
                BodyInterface bodyInterface = this.physicsWorld.getBodyInterface();
                int bodyId = this.chunkDataStore.bodyIds[index];
                if (bodyInterface != null && bodyId != 0 && bodyInterface.isAdded(bodyId)) {
                    bodyInterface.removeBody(bodyId);
                }
            });
        }
    }

    public void requestChunk(VxSectionPos pos) {
        int index;
        int n = index = this.chunkDataStore.addChunk(pos);
        this.chunkDataStore.referenceCounts[n] = this.chunkDataStore.referenceCounts[n] + 1;
        if (this.chunkDataStore.referenceCounts[n] == 1) {
            this.shapeGenerator.scheduleShapeGeneration(pos, index);
        }
    }

    public void releaseChunk(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index != null) {
            int n = index;
            this.chunkDataStore.referenceCounts[n] = this.chunkDataStore.referenceCounts[n] - 1;
            if (this.chunkDataStore.referenceCounts[n] == 0) {
                this.unloadChunkPhysicsInternal(pos);
            }
        }
    }

    private void unloadChunkPhysicsInternal(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index == null) {
            return;
        }
        this.chunkDataStore.states[index.intValue()] = 5;
        int n = index;
        this.chunkDataStore.rebuildVersions[n] = this.chunkDataStore.rebuildVersions[n] + 1;
        this.chunksToRebuild.remove(pos);
        this.physicsWorld.execute(() -> {
            this.removeBodyAndShape(index, this.physicsWorld.getBodyInterface());
            this.chunkDataStore.removeChunk(pos);
        });
    }

    private void removeBodyAndShape(int index, BodyInterface bodyInterface) {
        int bodyId = this.chunkDataStore.bodyIds[index];
        if (bodyId != 0 && bodyInterface != null) {
            if (bodyInterface.isAdded(bodyId)) {
                bodyInterface.removeBody(bodyId);
            }
            bodyInterface.destroyBody(bodyId);
        }
        this.chunkDataStore.bodyIds[index] = 0;
        this.chunkDataStore.setShape(index, null);
    }

    public boolean isTerrainBody(int bodyId) {
        if (bodyId <= 0) {
            return false;
        }
        for (int id : this.chunkDataStore.bodyIds) {
            if (id != bodyId) continue;
            return true;
        }
        return false;
    }

    public void cleanupAllBodies() {
        BodyInterface bi = this.physicsWorld.getBodyInterface();
        if (bi != null) {
            this.chunkDataStore.getManagedPositions().forEach(pos -> {
                Integer index = this.chunkDataStore.getIndexForPos((VxSectionPos)pos);
                if (index != null) {
                    this.removeBodyAndShape(index, bi);
                }
            });
        }
    }
}

