/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.management;

import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstBody;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.xmx.velthoric.physics.object.manager.VxObjectDataStore;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.terrain.data.VxChunkDataStore;
import net.xmx.velthoric.physics.terrain.data.VxSectionPos;
import net.xmx.velthoric.physics.terrain.management.VxTerrainManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxTerrainTracker {
    private final VxPhysicsWorld physicsWorld;
    private final VxTerrainManager terrainManager;
    private final VxChunkDataStore chunkDataStore;
    private final VxObjectDataStore objectDataStore;
    private final Map<UUID, Set<VxSectionPos>> objectTrackedChunks = new ConcurrentHashMap<UUID, Set<VxSectionPos>>();
    private final Map<UUID, Integer> objectUpdateCooldowns = new ConcurrentHashMap<UUID, Integer>();
    private static final int UPDATE_INTERVAL_TICKS = 10;
    private static final float MAX_SPEED_FOR_COOLDOWN_SQR = 10000.0f;
    private static final int PRELOAD_RADIUS_CHUNKS = 3;
    private static final int ACTIVATION_RADIUS_CHUNKS = 1;
    private static final float PREDICTION_SECONDS = 0.5f;
    private int objectUpdateIndex = 0;
    private static final int OBJECT_PRELOAD_UPDATE_STRIDE = 250;

    public VxTerrainTracker(VxPhysicsWorld physicsWorld, VxTerrainManager terrainManager, VxChunkDataStore chunkDataStore) {
        this.physicsWorld = physicsWorld;
        this.terrainManager = terrainManager;
        this.chunkDataStore = chunkDataStore;
        this.objectDataStore = physicsWorld.getObjectManager().getDataStore();
    }

    public void update() {
        ArrayList<VxBody> currentObjects = new ArrayList<VxBody>(this.physicsWorld.getObjectManager().getAllObjects());
        Set currentObjectIds = currentObjects.stream().map(VxBody::getPhysicsId).collect(Collectors.toSet());
        this.objectTrackedChunks.keySet().removeIf(id -> {
            if (!currentObjectIds.contains(id)) {
                this.removeObjectTracking((UUID)id);
                return true;
            }
            return false;
        });
        if (currentObjects.isEmpty()) {
            for (int index : this.chunkDataStore.getActiveIndices()) {
                if (this.chunkDataStore.states[index] != 4) continue;
                this.terrainManager.deactivateChunk(index);
            }
            return;
        }
        this.updatePreloadForObjects(currentObjects);
        Set<VxSectionPos> requiredActiveSet = this.calculateRequiredActiveSet(currentObjects);
        Iterator<Object> iterator = this.chunkDataStore.getActiveIndices().iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            VxSectionPos pos = this.chunkDataStore.getPosForIndex(index);
            if (pos == null || this.chunkDataStore.states[index] != 4 || requiredActiveSet.contains(pos)) continue;
            this.terrainManager.deactivateChunk(index);
        }
        for (VxSectionPos pos : requiredActiveSet) {
            Integer index = this.chunkDataStore.getIndexForPos(pos);
            if (index == null) continue;
            this.terrainManager.activateChunk(index);
        }
    }

    private Set<VxSectionPos> calculateRequiredActiveSet(List<VxBody> allObjects) {
        return allObjects.parallelStream().map(obj -> {
            HashSet<VxSectionPos> requiredForObj = new HashSet<VxSectionPos>();
            ConstBody body = obj.getConstBody();
            if (body != null) {
                ConstAaBox bounds = body.getWorldSpaceBounds();
                this.calculateRequiredChunks(bounds.getMin().getX(), bounds.getMin().getY(), bounds.getMin().getZ(), bounds.getMax().getX(), bounds.getMax().getY(), bounds.getMax().getZ(), body.getLinearVelocity().getX(), body.getLinearVelocity().getY(), body.getLinearVelocity().getZ(), 1, requiredForObj);
            }
            return requiredForObj;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private void updatePreloadForObjects(List<VxBody> currentObjects) {
        int objectsToUpdate = Math.min(currentObjects.size(), 250);
        for (int i = 0; i < objectsToUpdate; ++i) {
            VxBody obj;
            if (this.objectUpdateIndex >= currentObjects.size()) {
                this.objectUpdateIndex = 0;
            }
            if ((obj = currentObjects.get(this.objectUpdateIndex++)).getBodyId() != 0) {
                this.updatePreloadForObject(obj);
                continue;
            }
            this.removeObjectTracking(obj.getPhysicsId());
        }
    }

    private void updatePreloadForObject(VxBody obj) {
        UUID id = obj.getPhysicsId();
        int dataIndex = obj.getDataStoreIndex();
        if (dataIndex == -1) {
            this.removeObjectTracking(id);
            return;
        }
        int cooldown = this.objectUpdateCooldowns.getOrDefault(id, 0);
        float velX = this.objectDataStore.velX[dataIndex];
        float velY = this.objectDataStore.velY[dataIndex];
        float velZ = this.objectDataStore.velZ[dataIndex];
        float velSq = velX * velX + velY * velY + velZ * velZ;
        if (cooldown > 0 && velSq < 10000.0f) {
            this.objectUpdateCooldowns.put(id, cooldown - 1);
            return;
        }
        this.objectUpdateCooldowns.put(id, 10);
        HashSet<VxSectionPos> required = new HashSet<VxSectionPos>();
        ConstBody body = obj.getConstBody();
        if (body == null) {
            this.removeObjectTracking(id);
            return;
        }
        ConstAaBox bounds = body.getWorldSpaceBounds();
        this.calculateRequiredChunks(bounds.getMin().getX(), bounds.getMin().getY(), bounds.getMin().getZ(), bounds.getMax().getX(), bounds.getMax().getY(), bounds.getMax().getZ(), velX, velY, velZ, 3, required);
        Set previouslyTracked = this.objectTrackedChunks.computeIfAbsent(id, k -> new HashSet());
        previouslyTracked.removeIf(pos -> {
            if (!required.contains(pos)) {
                this.terrainManager.releaseChunk((VxSectionPos)pos);
                return true;
            }
            return false;
        });
        for (VxSectionPos pos2 : required) {
            if (!previouslyTracked.add(pos2)) continue;
            this.terrainManager.requestChunk(pos2);
        }
    }

    public void removeObjectTracking(UUID id) {
        Set<VxSectionPos> chunksToRelease = this.objectTrackedChunks.remove(id);
        if (chunksToRelease != null) {
            chunksToRelease.forEach(this.terrainManager::releaseChunk);
        }
        this.objectUpdateCooldowns.remove(id);
    }

    private void calculateRequiredChunks(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float velX, float velY, float velZ, int radius, Set<VxSectionPos> outChunks) {
        this.addChunksForBounds(minX, minY, minZ, maxX, maxY, maxZ, radius, outChunks);
        double predMinX = minX + (double)(velX * 0.5f);
        double predMinY = minY + (double)(velY * 0.5f);
        double predMinZ = minZ + (double)(velZ * 0.5f);
        double predMaxX = maxX + (double)(velX * 0.5f);
        double predMaxY = maxY + (double)(velY * 0.5f);
        double predMaxZ = maxZ + (double)(velZ * 0.5f);
        this.addChunksForBounds(predMinX, predMinY, predMinZ, predMaxX, predMaxY, predMaxZ, radius, outChunks);
    }

    private void addChunksForBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int radiusInChunks, Set<VxSectionPos> outChunks) {
        int minSectionX = ((int)Math.floor(minX) >> 4) - radiusInChunks;
        int minSectionY = ((int)Math.floor(minY) >> 4) - radiusInChunks;
        int minSectionZ = ((int)Math.floor(minZ) >> 4) - radiusInChunks;
        int maxSectionX = ((int)Math.floor(maxX) >> 4) + radiusInChunks;
        int maxSectionY = ((int)Math.floor(maxY) >> 4) + radiusInChunks;
        int maxSectionZ = ((int)Math.floor(maxZ) >> 4) + radiusInChunks;
        int worldMinY = this.physicsWorld.getLevel().method_31607() >> 4;
        int worldMaxY = this.physicsWorld.getLevel().method_31600() >> 4;
        for (int y = minSectionY; y <= maxSectionY; ++y) {
            if (y < worldMinY || y >= worldMaxY) continue;
            for (int z = minSectionZ; z <= maxSectionZ; ++z) {
                for (int x = minSectionX; x <= maxSectionX; ++x) {
                    outChunks.add(new VxSectionPos(x, y, z));
                }
            }
        }
    }

    public void clear() {
        this.objectTrackedChunks.clear();
        this.objectUpdateCooldowns.clear();
    }
}

