/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.world.pcmd;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import net.xmx.velthoric.physics.world.pcmd.ICommand;

public final class RunTaskCommand
implements ICommand {
    private static final Queue<RunTaskCommand> POOL = new ConcurrentLinkedQueue<RunTaskCommand>();
    private static final int MAX_POOL_SIZE = 1024;
    private Runnable task;

    private RunTaskCommand() {
    }

    private void setTask(Runnable task) {
        this.task = task;
    }

    private static RunTaskCommand acquire() {
        RunTaskCommand command = POOL.poll();
        if (command == null) {
            command = new RunTaskCommand();
        }
        return command;
    }

    private static void release(RunTaskCommand command) {
        command.setTask(null);
        if (POOL.size() < 1024) {
            POOL.offer(command);
        }
    }

    public static void queue(VxPhysicsWorld physicsWorld, Runnable task) {
        if (physicsWorld == null || task == null) {
            return;
        }
        RunTaskCommand command = RunTaskCommand.acquire();
        command.setTask(task);
        physicsWorld.queueCommand(command);
    }

    @Override
    public void execute(VxPhysicsWorld world) {
        if (this.task != null) {
            try {
                this.task.run();
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Exception during execution of pooled task for dimension {}: {}", (Object)world.getDimensionKey().method_29177(), (Object)e.getMessage(), (Object)e);
            }
        }
        RunTaskCommand.release(this);
    }
}

