/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.vxnative;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.xmx.vxnative.Arch;
import net.xmx.vxnative.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxNativeLibraryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Velthoric Native Loader");
    private static volatile boolean loaded = false;

    public static void load(Path extractionPath) {
        if (loaded) {
            return;
        }
        try {
            String resourcePath = VxNativeLibraryLoader.getNativeLibraryResourcePath();
            if (resourcePath == null) {
                throw new UnsupportedOperationException("Unsupported platform: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
            }
            String libFileName = resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
            Path targetFile = extractionPath.resolve(libFileName);
            LOGGER.debug("Native library target path: {}", (Object)targetFile.toAbsolutePath());
            boolean needsExtraction = true;
            if (Files.exists(targetFile, new LinkOption[0])) {
                String resourceHash;
                String existingFileHash = VxNativeLibraryLoader.calculateFileHash(targetFile);
                if (existingFileHash.equals(resourceHash = VxNativeLibraryLoader.calculateResourceHash(resourcePath))) {
                    LOGGER.debug("Native library '{}' is up-to-date. Skipping extraction.", (Object)libFileName);
                    needsExtraction = false;
                } else {
                    LOGGER.debug("Hash mismatch for '{}'. Re-extracting library.", (Object)libFileName);
                }
            }
            if (needsExtraction) {
                LOGGER.debug("Extracting native library '{}' to '{}'", (Object)resourcePath, (Object)targetFile);
                Files.createDirectories(extractionPath, new FileAttribute[0]);
                String pathForClassLoader = resourcePath.substring(1);
                try (InputStream source = Thread.currentThread().getContextClassLoader().getResourceAsStream(pathForClassLoader);){
                    if (source == null) {
                        throw new IOException("Native library '" + resourcePath + "' not found in classpath.");
                    }
                    Files.copy(source, targetFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            System.load(targetFile.toAbsolutePath().toString());
            loaded = true;
            LOGGER.debug("Successfully loaded native Jolt library: {}", (Object)libFileName);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load the native Jolt library", (Throwable)e);
            throw new RuntimeException("Could not load the native Jolt library.", e);
        }
    }

    private static String getNativeLibraryResourcePath() {
        OS os = OS.detect();
        Arch arch = Arch.detect();
        if (os == null || arch == null) {
            return null;
        }
        String libName = System.mapLibraryName("joltjni");
        return String.format("/%s/%s/com/github/stephengold/%s", os.folder, arch.folder, libName);
    }

    private static String calculateHash(InputStream in) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[8192];
        try (DigestInputStream dis = new DigestInputStream(in, md);){
            while (dis.read(buffer) != -1) {
            }
        }
        return String.format("%064x", new BigInteger(1, md.digest()));
    }

    private static String calculateFileHash(Path path) throws IOException, NoSuchAlgorithmException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            String string = VxNativeLibraryLoader.calculateHash(in);
            return string;
        }
    }

    private static String calculateResourceHash(String resourcePath) throws IOException, NoSuchAlgorithmException {
        String pathForClassLoader = resourcePath.substring(1);
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(pathForClassLoader);){
            if (in == null) {
                throw new IOException("Resource '" + resourcePath + "' not found in classpath.");
            }
            String string = VxNativeLibraryLoader.calculateHash(in);
            return string;
        }
    }
}

