/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstIndexedTriangle;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.ConstTriangle;
import com.github.stephengold.joltjni.readonly.ConstVertexList;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class AaBox
extends JoltPhysicsObject
implements ConstAaBox {
    public AaBox() {
        long boxVa = AaBox.createDefault();
        this.setVirtualAddress(boxVa, () -> AaBox.free(boxVa));
    }

    public AaBox(ConstAaBox original) {
        long originalVa = original.targetVa();
        long copyVa = AaBox.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> AaBox.free(copyVa));
    }

    AaBox(JoltPhysicsObject container, long boxVa) {
        super(container, boxVa);
    }

    AaBox(long boxVa, boolean owner) {
        Runnable freeingAction = owner ? () -> AaBox.free(boxVa) : null;
        this.setVirtualAddress(boxVa, freeingAction);
    }

    public AaBox(RVec3Arg minimum, RVec3Arg maximum) {
        float minX = minimum.x();
        float minY = minimum.y();
        float minZ = minimum.z();
        float maxX = maximum.x();
        float maxY = maximum.y();
        float maxZ = maximum.z();
        long boxVa = AaBox.createAaBox(minX, minY, minZ, maxX, maxY, maxZ);
        this.setVirtualAddress(boxVa, () -> AaBox.free(boxVa));
    }

    public AaBox(Vec3Arg center, float halfExtent) {
        float cx = center.getX();
        float cy = center.getY();
        float cz = center.getZ();
        long boxVa = AaBox.createCubic(cx, cy, cz, halfExtent);
        this.setVirtualAddress(boxVa, () -> AaBox.free(boxVa));
    }

    public AaBox(Vec3Arg minimum, Vec3Arg maximum) {
        float minX = minimum.getX();
        float minY = minimum.getY();
        float minZ = minimum.getZ();
        float maxX = maximum.getX();
        float maxY = maximum.getY();
        float maxZ = maximum.getZ();
        long boxVa = AaBox.createAaBox(minX, minY, minZ, maxX, maxY, maxZ);
        this.setVirtualAddress(boxVa, () -> AaBox.free(boxVa));
    }

    public void encapsulate(ConstAaBox includeBox) {
        long boxVa = this.va();
        long includeBoxVa = includeBox.targetVa();
        AaBox.encapsulateBox(boxVa, includeBoxVa);
    }

    public void encapsulate(ConstTriangle triangle) {
        long boxVa = this.va();
        long triangleVa = triangle.targetVa();
        AaBox.encapsulateTriangle(boxVa, triangleVa);
    }

    public void encapsulate(Vec3Arg location) {
        long boxVa = this.va();
        float locX = location.getX();
        float locY = location.getY();
        float locZ = location.getZ();
        AaBox.encapsulate(boxVa, locX, locY, locZ);
    }

    public void encapsulate(ConstVertexList vertices, ConstIndexedTriangle triangle) {
        long boxVa = this.va();
        long triangleVa = triangle.targetVa();
        int numVertices = vertices.size();
        FloatBuffer directBuffer = vertices.toDirectBuffer();
        AaBox.encapsulatedTriangleFromVertices(boxVa, numVertices, directBuffer, triangleVa);
    }

    public void ensureMinimalEdgeLength(float minEdgeLength) {
        long boxVa = this.va();
        AaBox.ensureMinimalEdgeLength(boxVa, minEdgeLength);
    }

    public void expandBy(Vec3Arg deltas) {
        long boxVa = this.va();
        float dx = deltas.getX();
        float dy = deltas.getY();
        float dz = deltas.getZ();
        AaBox.expandBy(boxVa, dx, dy, dz);
    }

    public static AaBox sBiggest() {
        long boxVa = AaBox.createBiggest();
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    public void setEmpty() {
        long boxVa = this.va();
        AaBox.setEmpty(boxVa);
    }

    public void setMax(Vec3Arg max) {
        long boxVa = this.va();
        float x = max.getX();
        float y = max.getY();
        float z = max.getZ();
        AaBox.setMax(boxVa, x, y, z);
    }

    public void setMin(Vec3Arg min) {
        long boxVa = this.va();
        float x = min.getX();
        float y = min.getY();
        float z = min.getZ();
        AaBox.setMin(boxVa, x, y, z);
    }

    public void translate(Vec3Arg offset) {
        long boxVa = this.va();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        AaBox.translate(boxVa, x, y, z);
    }

    @Override
    public boolean contains(ConstAaBox other) {
        long boxVa = this.va();
        long otherBoxVa = other.targetVa();
        boolean result = AaBox.containsAaBox(boxVa, otherBoxVa);
        return result;
    }

    @Override
    public boolean contains(Vec3Arg point) {
        long boxVa = this.va();
        float x = point.getX();
        float y = point.getY();
        float z = point.getZ();
        boolean result = AaBox.contains(boxVa, x, y, z);
        return result;
    }

    @Override
    public Vec3 getCenter() {
        long boxVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        AaBox.getCenter(boxVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getClosestPoint(Vec3Arg location) {
        long boxVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        location.copyTo(floatBuffer);
        AaBox.getClosestPoint(boxVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public Vec3 getExtent() {
        long boxVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        AaBox.getExtent(boxVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getMax() {
        long boxVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        AaBox.getMax(boxVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getMin() {
        long boxVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        AaBox.getMin(boxVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getSize() {
        long boxVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        AaBox.getSize(boxVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getSqDistanceTo(Vec3Arg point) {
        long boxVa = this.va();
        float px = point.getX();
        float py = point.getY();
        float pz = point.getZ();
        float result = AaBox.getSqDistanceTo(boxVa, px, py, pz);
        return result;
    }

    @Override
    public Vec3 getSupport(Vec3Arg direction) {
        long boxVa = this.va();
        FloatBuffer tmpFloats = Temporaries.floatBuffer1.get();
        direction.copyTo(tmpFloats);
        AaBox.getSupport(boxVa, tmpFloats);
        Vec3 vec3 = new Vec3(tmpFloats);
        return vec3;
    }

    @Override
    public float getSurfaceArea() {
        long boxVa = this.va();
        float result = AaBox.getSurfaceArea(boxVa);
        return result;
    }

    @Override
    public float getVolume() {
        long boxVa = this.va();
        float result = AaBox.getVolume(boxVa);
        return result;
    }

    @Override
    public boolean isValid() {
        long boxVa = this.va();
        boolean result = AaBox.isValid(boxVa);
        return result;
    }

    @Override
    public boolean overlaps(ConstAaBox other) {
        long boxVa = this.va();
        long otherVa = other.targetVa();
        boolean result = AaBox.overlapsAaBox(boxVa, otherVa);
        return result;
    }

    @Override
    public boolean overlaps(ConstPlane plane) {
        long boxVa = this.va();
        float pc = plane.getConstant();
        float pnx = plane.getNormalX();
        float pny = plane.getNormalY();
        float pnz = plane.getNormalZ();
        boolean result = AaBox.overlaps(boxVa, pc, pnx, pny, pnz);
        return result;
    }

    @Override
    public AaBox scaled(Vec3Arg factors) {
        long boxVa = this.va();
        float sx = factors.getX();
        float sy = factors.getY();
        float sz = factors.getZ();
        long resultVa = AaBox.scaled(boxVa, sx, sy, sz);
        AaBox result = new AaBox(resultVa, true);
        return result;
    }

    @Override
    public AaBox transformed(Mat44Arg matrix) {
        long boxVa = this.va();
        long matrixVa = matrix.targetVa();
        long resultVa = AaBox.transformed(boxVa, matrixVa);
        AaBox result = new AaBox(resultVa, true);
        return result;
    }

    private static native boolean contains(long var0, float var2, float var3, float var4);

    private static native boolean containsAaBox(long var0, long var2);

    private static native long createAaBox(float var0, float var1, float var2, float var3, float var4, float var5);

    private static native long createBiggest();

    private static native long createCubic(float var0, float var1, float var2, float var3);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void encapsulate(long var0, float var2, float var3, float var4);

    private static native void encapsulateBox(long var0, long var2);

    private static native void encapsulateTriangle(long var0, long var2);

    private static native void encapsulatedTriangleFromVertices(long var0, int var2, FloatBuffer var3, long var4);

    private static native void ensureMinimalEdgeLength(long var0, float var2);

    private static native void expandBy(long var0, float var2, float var3, float var4);

    private static native void free(long var0);

    private static native void getCenter(long var0, FloatBuffer var2);

    private static native void getClosestPoint(long var0, FloatBuffer var2);

    private static native void getExtent(long var0, FloatBuffer var2);

    private static native void getMax(long var0, FloatBuffer var2);

    private static native void getMin(long var0, FloatBuffer var2);

    private static native void getSize(long var0, FloatBuffer var2);

    private static native float getSqDistanceTo(long var0, float var2, float var3, float var4);

    private static native float getSurfaceArea(long var0);

    private static native void getSupport(long var0, FloatBuffer var2);

    private static native float getVolume(long var0);

    private static native boolean overlaps(long var0, float var2, float var3, float var4, float var5);

    private static native boolean overlapsAaBox(long var0, long var2);

    private static native boolean isValid(long var0);

    private static native long scaled(long var0, float var2, float var3, float var4);

    private static native void setEmpty(long var0);

    private static native void setMax(long var0, float var2, float var3, float var4);

    private static native void setMin(long var0, float var2, float var3, float var4);

    private static native long transformed(long var0, long var2);

    private static native void translate(long var0, float var2, float var3, float var4);
}

