/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyManager;
import com.github.stephengold.joltjni.template.Array;

public class BodyVector
extends Array<Body> {
    BodyVector(BodyManager manager, long vectorVa) {
        super(manager, vectorVa);
    }

    public BodyManager getManager() {
        return (BodyManager)this.getContainingObject();
    }

    @Override
    public int capacity() {
        long vectorVa = this.va();
        int result = BodyVector.capacity(vectorVa);
        return result;
    }

    @Override
    public void erase(int startIndex, int stopIndex) {
        long vectorVa = this.va();
        BodyVector.erase(vectorVa, startIndex, stopIndex);
    }

    @Override
    public Body get(int elementIndex) {
        Body result;
        long vectorVa = this.va();
        long bodyVa = BodyVector.getBody(vectorVa, elementIndex);
        if (bodyVa == 0L) {
            result = null;
        } else {
            BodyManager manager = this.getManager();
            result = new Body(manager, bodyVa);
        }
        return result;
    }

    @Override
    public void resize(int numBodies) {
        long vectorVa = this.va();
        BodyVector.resize(vectorVa, numBodies);
    }

    @Override
    public void set(int elementIndex, Body body) {
        long vectorVa = this.va();
        long bodyVa = body.va();
        BodyVector.setBody(vectorVa, elementIndex, bodyVa);
    }

    @Override
    public int size() {
        long vectorVa = this.va();
        int result = BodyVector.size(vectorVa);
        return result;
    }

    private static native int capacity(long var0);

    private static native void erase(long var0, int var2, int var3);

    private static native long getBody(long var0, int var2);

    private static native void resize(long var0, int var2);

    private static native void setBody(long var0, int var2, long var3);

    private static native int size(long var0);
}

