/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyIdArray;
import com.github.stephengold.joltjni.BodyManager;
import com.github.stephengold.joltjni.BroadPhaseQuery;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseLayerInterface;

public abstract class BroadPhase
extends BroadPhaseQuery {
    BroadPhase() {
    }

    public void addBodiesAbort(BodyIdArray bodyIds, long addState) {
        int numBodies = bodyIds.length();
        this.addBodiesAbort(bodyIds, numBodies, addState);
    }

    public void addBodiesAbort(BodyIdArray bodyIds, int numBodies, long addState) {
        long phaseVa = this.va();
        long arrayVa = bodyIds.va();
        BroadPhase.addBodiesAbort(phaseVa, arrayVa, numBodies, addState);
    }

    public void addBodiesFinalize(BodyIdArray bodyIds, long addState) {
        int numBodies = bodyIds.length();
        this.addBodiesFinalize(bodyIds, numBodies, addState);
    }

    public void addBodiesFinalize(BodyIdArray bodyIds, int numBodies, long addState) {
        long phaseVa = this.va();
        long arrayVa = bodyIds.va();
        BroadPhase.addBodiesFinalize(phaseVa, arrayVa, numBodies, addState);
    }

    public long addBodiesPrepare(BodyIdArray bodyIds) {
        int numBodies = bodyIds.length();
        long result = this.addBodiesPrepare(bodyIds, numBodies);
        return result;
    }

    public long addBodiesPrepare(BodyIdArray bodyIds, int numBodies) {
        long phaseVa = this.va();
        long arrayVa = bodyIds.va();
        long result = BroadPhase.addBodiesPrepare(phaseVa, arrayVa, numBodies);
        return result;
    }

    public void init(BodyManager manager, ConstBroadPhaseLayerInterface map) {
        long phaseVa = this.va();
        long managerVa = manager.va();
        long mapVa = map.targetVa();
        BroadPhase.init(phaseVa, managerVa, mapVa);
    }

    public void optimize() {
        long phaseVa = this.va();
        BroadPhase.optimize(phaseVa);
    }

    public void notifyBodiesAabbChanged(BodyIdArray bodyIds, int numBodies) {
        this.notifyBodiesAabbChanged(bodyIds, numBodies, true);
    }

    public void notifyBodiesAabbChanged(BodyIdArray bodyIds, int numBodies, boolean takeLock) {
        long phaseVa = this.va();
        long arrayVa = bodyIds.va();
        BroadPhase.notifyBodiesAabbChanged(phaseVa, arrayVa, numBodies, takeLock);
    }

    public void removeBodies(BodyIdArray bodyIds, int numBodies) {
        long phaseVa = this.va();
        long arrayVa = bodyIds.va();
        BroadPhase.removeBodies(phaseVa, arrayVa, numBodies);
    }

    private static native void addBodiesAbort(long var0, long var2, int var4, long var5);

    private static native void addBodiesFinalize(long var0, long var2, int var4, long var5);

    private static native long addBodiesPrepare(long var0, long var2, int var4);

    private static native void init(long var0, long var2, long var4);

    private static native void optimize(long var0);

    private static native void notifyBodiesAabbChanged(long var0, long var2, int var4, boolean var5);

    private static native void removeBodies(long var0, long var2, int var4);
}

