/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CharacterBaseSettings;
import com.github.stephengold.joltjni.CharacterVirtualSettingsRef;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EBackFaceMode;
import com.github.stephengold.joltjni.readonly.ConstCharacterVirtualSettings;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.RefTarget;
import java.nio.FloatBuffer;

public class CharacterVirtualSettings
extends CharacterBaseSettings
implements ConstCharacterVirtualSettings,
RefTarget {
    public CharacterVirtualSettings() {
        long settingsVa = CharacterVirtualSettings.createCharacterVirtualSettings();
        long refVa = CharacterVirtualSettings.toRef(settingsVa);
        Runnable freeingAction = () -> CharacterVirtualSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public CharacterVirtualSettings(ConstCharacterVirtualSettings original) {
        long originalVa = original.targetVa();
        long copyVa = CharacterVirtualSettings.createCopy(originalVa);
        long refVa = CharacterVirtualSettings.toRef(copyVa);
        Runnable freeingAction = () -> CharacterVirtualSettingsRef.free(refVa);
        this.setVirtualAddress(copyVa, freeingAction);
    }

    CharacterVirtualSettings(long settingsVa) {
        long refVa = CharacterVirtualSettings.toRef(settingsVa);
        Runnable freeingAction = () -> CharacterVirtualSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public void setBackFaceMode(EBackFaceMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        CharacterVirtualSettings.setBackFaceMode(settingsVa, ordinal);
    }

    public void setCharacterPadding(float padding) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setCharacterPadding(settingsVa, padding);
    }

    public void setCollisionTolerance(float tolerance) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setCollisionTolerance(settingsVa, tolerance);
    }

    public void setHitReductionCosMaxAngle(int cosine) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setHitReductionCosMaxAngle(settingsVa, cosine);
    }

    public void setInnerBodyLayer(int objectLayer) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setInnerBodyLayer(settingsVa, objectLayer);
    }

    public void setInnerBodyShape(ConstShape shape) {
        long settingsVa = this.va();
        long shapeVa = shape == null ? 0L : shape.targetVa();
        CharacterVirtualSettings.setInnerBodyShape(settingsVa, shapeVa);
    }

    public void setMass(float mass) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setMass(settingsVa, mass);
    }

    public void setMaxCollisionIterations(int numIterations) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setMaxCollisionIterations(settingsVa, numIterations);
    }

    public void setMaxConstraintIterations(int numIterations) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setMaxConstraintIterations(settingsVa, numIterations);
    }

    public void setMaxNumHits(int numHits) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setMaxNumHits(settingsVa, numHits);
    }

    public void setMaxStrength(float force) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setMaxStrength(settingsVa, force);
    }

    public void setMinTimeRemaining(float interval) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setMinTimeRemaining(settingsVa, interval);
    }

    public void setPenetrationRecoverySpeed(float fraction) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setPenetrationRecoverySpeed(settingsVa, fraction);
    }

    public void setPredictiveContactDistance(float distance) {
        long settingsVa = this.va();
        CharacterVirtualSettings.setPredictiveContactDistance(settingsVa, distance);
    }

    public void setShapeOffset(Vec3Arg offset) {
        long settingsVa = this.va();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        CharacterVirtualSettings.setShapeOffset(settingsVa, x, y, z);
    }

    @Override
    public EBackFaceMode getBackFaceMode() {
        long settingsVa = this.va();
        int ordinal = CharacterVirtualSettings.getBackFaceMode(settingsVa);
        EBackFaceMode result = EBackFaceMode.values()[ordinal];
        return result;
    }

    @Override
    public float getCharacterPadding() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getCharacterPadding(settingsVa);
        return result;
    }

    @Override
    public float getCollisionTolerance() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getCollisionTolerance(settingsVa);
        return result;
    }

    @Override
    public float getHitReductionCosMaxAngle() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getHitReductionCosMaxAngle(settingsVa);
        return result;
    }

    @Override
    public int getInnerBodyLayer() {
        long settingsVa = this.va();
        int result = CharacterVirtualSettings.getInnerBodyLayer(settingsVa);
        return result;
    }

    @Override
    public ConstShape getInnerBodyShape() {
        long settingsVa = this.va();
        long shapeVa = CharacterVirtualSettings.getInnerBodyShape(settingsVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public float getMass() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getMass(settingsVa);
        return result;
    }

    @Override
    public int getMaxCollisionIterations() {
        long settingsVa = this.va();
        int result = CharacterVirtualSettings.getMaxCollisionIterations(settingsVa);
        return result;
    }

    @Override
    public int getMaxConstraintIterations() {
        long settingsVa = this.va();
        int result = CharacterVirtualSettings.getMaxConstraintIterations(settingsVa);
        return result;
    }

    @Override
    public int getMaxNumHits() {
        long settingsVa = this.va();
        int result = CharacterVirtualSettings.getMaxNumHits(settingsVa);
        return result;
    }

    @Override
    public float getMaxStrength() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getMaxStrength(settingsVa);
        return result;
    }

    @Override
    public float getMinTimeRemaining() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getMinTimeRemaining(settingsVa);
        return result;
    }

    @Override
    public float getPenetrationRecoverySpeed() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getPenetrationRecoverySpeed(settingsVa);
        return result;
    }

    @Override
    public float getPredictiveContactDistance() {
        long settingsVa = this.va();
        float result = CharacterVirtualSettings.getPredictiveContactDistance(settingsVa);
        return result;
    }

    @Override
    public Vec3 getShapeOffset() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtualSettings.getShapeOffset(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        CharacterVirtualSettings.setEmbedded(settingsVa);
    }

    @Override
    public CharacterVirtualSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = CharacterVirtualSettings.toRef(settingsVa);
        CharacterVirtualSettingsRef result = new CharacterVirtualSettingsRef(refVa, true);
        return result;
    }

    private static native long createCharacterVirtualSettings();

    private static native long createCopy(long var0);

    static native int getBackFaceMode(long var0);

    static native float getCharacterPadding(long var0);

    static native float getCollisionTolerance(long var0);

    static native float getHitReductionCosMaxAngle(long var0);

    static native int getInnerBodyLayer(long var0);

    static native long getInnerBodyShape(long var0);

    static native float getMass(long var0);

    static native int getMaxCollisionIterations(long var0);

    static native int getMaxConstraintIterations(long var0);

    static native int getMaxNumHits(long var0);

    static native float getMaxStrength(long var0);

    static native float getMinTimeRemaining(long var0);

    static native float getPenetrationRecoverySpeed(long var0);

    static native float getPredictiveContactDistance(long var0);

    static native void getShapeOffset(long var0, FloatBuffer var2);

    static native void setBackFaceMode(long var0, int var2);

    static native void setCharacterPadding(long var0, float var2);

    static native void setCollisionTolerance(long var0, float var2);

    private static native void setEmbedded(long var0);

    static native void setHitReductionCosMaxAngle(long var0, float var2);

    static native void setInnerBodyLayer(long var0, int var2);

    static native void setInnerBodyShape(long var0, long var2);

    static native void setMass(long var0, float var2);

    static native void setMaxCollisionIterations(long var0, int var2);

    static native void setMaxConstraintIterations(long var0, int var2);

    static native void setMaxNumHits(long var0, int var2);

    static native void setMaxStrength(long var0, float var2);

    static native void setMinTimeRemaining(long var0, float var2);

    static native void setPenetrationRecoverySpeed(long var0, float var2);

    static native void setPredictiveContactDistance(long var0, float var2);

    static native void setShapeOffset(long var0, float var2, float var3, float var4);

    private static native long toRef(long var0);
}

