/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.ShapeList;
import com.github.stephengold.joltjni.SubShape;
import com.github.stephengold.joltjni.SubShapeIdCreator;
import com.github.stephengold.joltjni.readonly.ConstSubShape;

public abstract class CompoundShape
extends Shape {
    CompoundShape() {
    }

    public int getNumSubShapes() {
        long shapeVa = this.va();
        int result = CompoundShape.getNumSubShapes(shapeVa);
        return result;
    }

    public ConstSubShape getSubShape(int subShapeIndex) {
        long shapeVa = this.va();
        long subShapeVa = CompoundShape.getSubShape(shapeVa, subShapeIndex);
        SubShape result = new SubShape(subShapeVa);
        return result;
    }

    public SubShapeIdCreator getSubShapeIdFromIndex(int subShapeIndex, SubShapeIdCreator parent) {
        long shapeVa = this.va();
        long parentVa = parent.va();
        long creatorVa = CompoundShape.getSubShapeIdFromIndex(shapeVa, subShapeIndex, parentVa);
        SubShapeIdCreator result = new SubShapeIdCreator(creatorVa, true);
        return result;
    }

    public ConstSubShape[] getSubShapes() {
        long shapeVa = this.va();
        int numSubShapes = this.getNumSubShapes();
        ConstSubShape[] result = new SubShape[numSubShapes];
        for (int i = 0; i < numSubShapes; ++i) {
            long subShapeVa = CompoundShape.getSubShape(shapeVa, i);
            result[i] = new SubShape(subShapeVa);
        }
        return result;
    }

    public void restoreSubShapeState(ShapeList subshapes) {
        long shapeVa = this.va();
        long listVa = subshapes.va();
        CompoundShape.restoreSubShapeState(shapeVa, listVa);
    }

    private static native int getNumSubShapes(long var0);

    private static native long getSubShape(long var0, int var2);

    private static native long getSubShapeIdFromIndex(long var0, int var2, long var3);

    private static native void restoreSubShapeState(long var0, long var2);
}

