/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JobSystemWithBarrier;

public class JobSystemThreadPool
extends JobSystemWithBarrier {
    public JobSystemThreadPool(int maxJobs, int maxBarriers) {
        this(maxJobs, maxBarriers, -1);
    }

    public JobSystemThreadPool(int maxJobs, int maxBarriers, int numThreads) {
        assert (maxJobs > 1 && (maxJobs & maxJobs - 1) == 0) : "maxJobs = " + maxJobs;
        long systemVa = JobSystemThreadPool.createJobSystem(maxJobs, maxBarriers, numThreads);
        this.setVirtualAddress(systemVa, () -> JobSystemThreadPool.free(systemVa));
    }

    public void setNumThreads(int numThreads) {
        long systemVa = this.va();
        JobSystemThreadPool.setNumThreads(systemVa, numThreads);
    }

    private static native long createJobSystem(int var0, int var1, int var2);

    private static native void free(long var0);

    private static native void setNumThreads(long var0, int var2);
}

