/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.PhysicsScene;
import com.github.stephengold.joltjni.RagdollSettings;
import com.github.stephengold.joltjni.enumerate.EStreamType;
import com.github.stephengold.joltjni.readonly.ConstBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstJoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstSerializableObject;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstSoftBodySharedSettings;
import com.github.stephengold.joltjni.std.StringStream;

public final class ObjectStreamOut {
    private ObjectStreamOut() {
    }

    public static boolean sWriteObject(String fileName, EStreamType streamType, ConstJoltPhysicsObject writeObject) {
        boolean result;
        int ordinal = streamType.ordinal();
        long objVa = writeObject.targetVa();
        if (writeObject instanceof ConstSerializableObject) {
            result = ObjectStreamOut.sWriteSerializableObjectToFile(fileName, ordinal, objVa);
        } else if (writeObject instanceof ConstBodyCreationSettings) {
            result = ObjectStreamOut.sWriteBcsToFile(fileName, ordinal, objVa);
        } else if (writeObject instanceof ConstSoftBodyCreationSettings) {
            result = ObjectStreamOut.sWriteSbcsToFile(fileName, ordinal, objVa);
        } else if (writeObject instanceof ConstSoftBodySharedSettings) {
            result = ObjectStreamOut.sWriteSbssToFile(fileName, ordinal, objVa);
        } else if (writeObject instanceof PhysicsScene) {
            result = ObjectStreamOut.sWritePhysicsSceneToFile(fileName, ordinal, objVa);
        } else if (writeObject instanceof RagdollSettings) {
            result = ObjectStreamOut.sWriteRagdollSettingsToFile(fileName, ordinal, objVa);
        } else {
            Class<?> clas = writeObject.getClass();
            String className = clas.getSimpleName();
            throw new IllegalArgumentException(className);
        }
        return result;
    }

    public static boolean sWriteObject(StringStream stream, EStreamType streamType, ConstJoltPhysicsObject writeObject) {
        boolean result;
        long streamVa = stream.va();
        int ordinal = streamType.ordinal();
        long objVa = writeObject.targetVa();
        if (writeObject instanceof ConstSerializableObject) {
            result = ObjectStreamOut.sWriteSerializableObject(streamVa, ordinal, objVa);
        } else if (writeObject instanceof ConstBodyCreationSettings) {
            result = ObjectStreamOut.sWriteBcs(streamVa, ordinal, objVa);
        } else if (writeObject instanceof ConstSoftBodyCreationSettings) {
            result = ObjectStreamOut.sWriteSbcs(streamVa, ordinal, objVa);
        } else if (writeObject instanceof ConstSoftBodySharedSettings) {
            result = ObjectStreamOut.sWriteSbss(streamVa, ordinal, objVa);
        } else if (writeObject instanceof PhysicsScene) {
            result = ObjectStreamOut.sWritePhysicsScene(streamVa, ordinal, objVa);
        } else if (writeObject instanceof RagdollSettings) {
            result = ObjectStreamOut.sWriteRagdollSettings(streamVa, ordinal, objVa);
        } else {
            Class<?> clas = writeObject.getClass();
            String className = clas.getSimpleName();
            throw new IllegalArgumentException(className);
        }
        return result;
    }

    private static native boolean sWriteBcs(long var0, int var2, long var3);

    private static native boolean sWriteBcsToFile(String var0, int var1, long var2);

    private static native boolean sWritePhysicsScene(long var0, int var2, long var3);

    private static native boolean sWritePhysicsSceneToFile(String var0, int var1, long var2);

    private static native boolean sWriteRagdollSettings(long var0, int var2, long var3);

    private static native boolean sWriteRagdollSettingsToFile(String var0, int var1, long var2);

    private static native boolean sWriteSbcs(long var0, int var2, long var3);

    private static native boolean sWriteSbcsToFile(String var0, int var1, long var2);

    private static native boolean sWriteSbss(long var0, int var2, long var3);

    private static native boolean sWriteSbssToFile(String var0, int var1, long var2);

    private static native boolean sWriteSerializableObject(long var0, int var2, long var3);

    private static native boolean sWriteSerializableObjectToFile(String var0, int var1, long var2);
}

