/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DecoratedShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class OffsetCenterOfMassShape
extends DecoratedShape {
    public OffsetCenterOfMassShape(ConstShape baseShape, Vec3Arg offset) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        long baseShapeVa = baseShape.targetVa();
        long ocomShapeVa = OffsetCenterOfMassShape.createShape(baseShapeVa, offsetX, offsetY, offsetZ);
        this.setVirtualAddressAsCoOwner(ocomShapeVa);
    }

    OffsetCenterOfMassShape(long ocomShapeVa) {
        this.setVirtualAddressAsCoOwner(ocomShapeVa);
    }

    public Vec3 getOffset() {
        long ocomShapeVa = this.va();
        float offsetX = OffsetCenterOfMassShape.getOffsetX(ocomShapeVa);
        float offsetY = OffsetCenterOfMassShape.getOffsetY(ocomShapeVa);
        float offsetZ = OffsetCenterOfMassShape.getOffsetZ(ocomShapeVa);
        Vec3 result = new Vec3(offsetX, offsetY, offsetZ);
        return result;
    }

    private static native long createShape(long var0, float var2, float var3, float var4);

    private static native float getOffsetX(long var0);

    private static native float getOffsetY(long var0);

    private static native float getOffsetZ(long var0);
}

