/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.PathConstraintPath;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.EPathRotationConstraintType;
import com.github.stephengold.joltjni.readonly.ConstPathConstraintPath;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class PathConstraintSettings
extends TwoBodyConstraintSettings {
    public PathConstraintSettings() {
        long settingsVa = PathConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Path);
    }

    PathConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Path);
    }

    public PathConstraintSettings(PathConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = PathConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Path);
    }

    public float getMaxFrictionForce() {
        long settingsVa = this.va();
        float result = PathConstraintSettings.getMaxFrictionForce(settingsVa);
        return result;
    }

    public ConstPathConstraintPath getPath() {
        long settingsVa = this.va();
        long pathVa = PathConstraintSettings.getPath(settingsVa);
        PathConstraintPath result = PathConstraintPath.newPath(pathVa);
        return result;
    }

    public float getPathFraction() {
        long settingsVa = this.va();
        float result = PathConstraintSettings.getPathFraction(settingsVa);
        return result;
    }

    public Vec3 getPathPosition() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        PathConstraintSettings.getPathPosition(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Quat getPathRotation() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        PathConstraintSettings.getPathRotation(settingsVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    public MotorSettings getPositionMotorSettings() {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = PathConstraintSettings.getPositionMotorSettings(constraintSettingsVa);
        MotorSettings result = new MotorSettings(this, motorSettingsVa);
        return result;
    }

    public EPathRotationConstraintType getRotationConstraintType() {
        long settingsVa = this.va();
        int ordinal = PathConstraintSettings.getRotationConstraintType(settingsVa);
        EPathRotationConstraintType result = EPathRotationConstraintType.values()[ordinal];
        return result;
    }

    public void setMaxFrictionForce(float force) {
        long settingsVa = this.va();
        PathConstraintSettings.setMaxFrictionForce(settingsVa, force);
    }

    public void setPath(ConstPathConstraintPath path) {
        long settingsVa = this.va();
        long pathVa = path.targetVa();
        PathConstraintSettings.setPath(settingsVa, pathVa);
    }

    public void setPathFraction(float amount) {
        long settingsVa = this.va();
        PathConstraintSettings.setPathFraction(settingsVa, amount);
    }

    public void setPathPosition(Vec3Arg location) {
        long settingsVa = this.va();
        float locX = location.getX();
        float locY = location.getY();
        float locZ = location.getZ();
        PathConstraintSettings.setPathPosition(settingsVa, locX, locY, locZ);
    }

    public void setPathRotation(QuatArg orientation) {
        long settingsVa = this.va();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        PathConstraintSettings.setPathRotation(settingsVa, qx, qy, qz, qw);
    }

    public void setPositionMotorSettings(MotorSettings motorSettings) {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = motorSettings.va();
        PathConstraintSettings.setPositionMotorSettings(constraintSettingsVa, motorSettingsVa);
    }

    public void setRotationConstraintType(EPathRotationConstraintType type) {
        long settingsVa = this.va();
        int ordinal = type.ordinal();
        PathConstraintSettings.setRotationConstraintType(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native float getMaxFrictionForce(long var0);

    private static native long getPath(long var0);

    private static native float getPathFraction(long var0);

    private static native void getPathPosition(long var0, FloatBuffer var2);

    private static native void getPathRotation(long var0, FloatBuffer var2);

    private static native long getPositionMotorSettings(long var0);

    private static native int getRotationConstraintType(long var0);

    private static native void setMaxFrictionForce(long var0, float var2);

    private static native void setPath(long var0, long var2);

    private static native void setPathFraction(long var0, float var2);

    private static native void setPathPosition(long var0, float var2, float var3, float var4);

    private static native void setPathRotation(long var0, float var2, float var3, float var4, float var5);

    private static native void setPositionMotorSettings(long var0, long var2);

    private static native void setRotationConstraintType(long var0, int var2);
}

