/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.readonly.Vec4Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public final class RMat44
extends JoltPhysicsObject
implements RMat44Arg {
    public RMat44() {
        long matrixVa = RMat44.createUninitialized();
        this.setVirtualAddress(matrixVa, () -> RMat44.free(matrixVa));
    }

    RMat44(JoltPhysicsObject container, long matrixVa) {
        super(container, matrixVa);
    }

    RMat44(long matrixVa, boolean owner) {
        Runnable freeingAction = owner ? () -> RMat44.free(matrixVa) : null;
        this.setVirtualAddress(matrixVa, freeingAction);
    }

    public RMat44(Mat44Arg spMatrix) {
        long spMatrixVa = spMatrix.targetVa();
        long matrixVa = RMat44.createFromSpMatrix(spMatrixVa);
        this.setVirtualAddress(matrixVa, () -> RMat44.free(matrixVa));
    }

    public RMat44(RMat44Arg original) {
        long originalVa = original.targetVa();
        long matrixVa = RMat44.createCopy(originalVa);
        this.setVirtualAddress(matrixVa, () -> RMat44.free(matrixVa));
    }

    public RMat44(Vec4Arg c1, Vec4Arg c2, Vec4Arg c3, RVec3Arg c4) {
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        floatBuffer.put(0, c1.getX());
        floatBuffer.put(1, c2.getX());
        floatBuffer.put(2, c3.getX());
        floatBuffer.put(3, c1.getY());
        floatBuffer.put(4, c2.getY());
        floatBuffer.put(5, c3.getY());
        floatBuffer.put(6, c1.getZ());
        floatBuffer.put(7, c2.getZ());
        floatBuffer.put(8, c3.getZ());
        floatBuffer.put(9, c1.getW());
        floatBuffer.put(10, c2.getW());
        floatBuffer.put(11, c3.getW());
        double m14 = c4.xx();
        double m24 = c4.yy();
        double m34 = c4.zz();
        long matrixVa = RMat44.createFromRowMajor(floatBuffer, m14, m24, m34);
        this.setVirtualAddress(matrixVa, () -> RMat44.free(matrixVa));
    }

    public void leftMultiplyInPlace(RMat44Arg leftFactor) {
        long currentVa = this.va();
        long leftVa = leftFactor.targetVa();
        RMat44.leftMultiplyInPlace(currentVa, leftVa);
    }

    public void loadIdentity() {
        long matrixVa = this.va();
        RMat44.loadIdentity(matrixVa);
    }

    public static RMat44 product(RMat44Arg ... mArray) {
        long resultVa;
        int length = mArray.length;
        if (length == 0) {
            resultVa = RMat44.createIdentity();
        } else {
            long factorVa = mArray[0].targetVa();
            resultVa = RMat44.createCopy(factorVa);
            for (int i = 1; i < length; ++i) {
                factorVa = mArray[i].targetVa();
                RMat44.rightMultiplyInPlace(resultVa, factorVa);
            }
        }
        RMat44 result = new RMat44(resultVa, true);
        return result;
    }

    public void rightMultiplyInPlace(RMat44Arg rightFactor) {
        long currentVa = this.va();
        long rightVa = rightFactor.targetVa();
        RMat44.rightMultiplyInPlace(currentVa, rightVa);
    }

    public void set(RMat44Arg source) {
        long targetVa = this.va();
        long sourceVa = source.targetVa();
        RMat44.assign(targetVa, sourceVa);
    }

    public void setAxisX(Vec3Arg vec) {
        long matrixVa = this.va();
        float x = vec.getX();
        float y = vec.getY();
        float z = vec.getZ();
        RMat44.setAxisX(matrixVa, x, y, z);
    }

    public void setAxisY(Vec3Arg vec) {
        long matrixVa = this.va();
        float x = vec.getX();
        float y = vec.getY();
        float z = vec.getZ();
        RMat44.setAxisY(matrixVa, x, y, z);
    }

    public void setAxisZ(Vec3Arg vec) {
        long matrixVa = this.va();
        float x = vec.getX();
        float y = vec.getY();
        float z = vec.getZ();
        RMat44.setAxisZ(matrixVa, x, y, z);
    }

    public void setElement(int row, int column, double value) {
        assert (column >= 0 && column < 4) : "column = " + column;
        assert (row >= 0 && row < 4) : "row = " + row;
        long matrixVa = this.va();
        RMat44.setElement(matrixVa, row, column, value);
    }

    public void setTranslation(RVec3Arg offset) {
        long matrixVa = this.va();
        double xx = offset.xx();
        double yy = offset.yy();
        double zz = offset.zz();
        RMat44.setTranslation(matrixVa, xx, yy, zz);
    }

    public static RMat44 sIdentity() {
        long matrixVa = RMat44.createIdentity();
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    public static RMat44 sRotation(QuatArg rotation) {
        float rw = rotation.getW();
        float rx = rotation.getX();
        float ry = rotation.getY();
        float rz = rotation.getZ();
        long matrixVa = RMat44.createRotation(rx, ry, rz, rw);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    public static RMat44 sRotationTranslation(QuatArg rotation, RVec3Arg offset) {
        float qw = rotation.getW();
        float qx = rotation.getX();
        float qy = rotation.getY();
        float qz = rotation.getZ();
        double xx = offset.xx();
        double yy = offset.yy();
        double zz = offset.zz();
        long matrixVa = RMat44.createRotationTranslation(qx, qy, qz, qw, xx, yy, zz);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    public static RMat44 sScale(float factor) {
        long matrixVa = RMat44.createScale(factor, factor, factor);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    public static RMat44 sScale(Vec3Arg factors) {
        float x = factors.getX();
        float y = factors.getY();
        float z = factors.getZ();
        long matrixVa = RMat44.createScale(x, y, z);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    public static RMat44 sTranslation(RVec3Arg offset) {
        double xx = offset.xx();
        double yy = offset.yy();
        double zz = offset.zz();
        long matrixVa = RMat44.createTranslation(xx, yy, zz);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    public static RMat44 sZero() {
        long matrixVa = RMat44.createZero();
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public Vec3 getAxisX() {
        long matrixVa = this.va();
        float x = (float)RMat44.getElement(matrixVa, 0, 0);
        float y = (float)RMat44.getElement(matrixVa, 1, 0);
        float z = (float)RMat44.getElement(matrixVa, 2, 0);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public Vec3 getAxisY() {
        long matrixVa = this.va();
        float x = (float)RMat44.getElement(matrixVa, 0, 1);
        float y = (float)RMat44.getElement(matrixVa, 1, 1);
        float z = (float)RMat44.getElement(matrixVa, 2, 1);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public Vec3 getAxisZ() {
        long matrixVa = this.va();
        float x = (float)RMat44.getElement(matrixVa, 0, 2);
        float y = (float)RMat44.getElement(matrixVa, 1, 2);
        float z = (float)RMat44.getElement(matrixVa, 2, 2);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public Vec3 getDiagonal3() {
        long matrixVa = this.va();
        float x = (float)RMat44.getElement(matrixVa, 0, 0);
        float y = (float)RMat44.getElement(matrixVa, 1, 1);
        float z = (float)RMat44.getElement(matrixVa, 2, 2);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public double getElement(int row, int column) {
        assert (column >= 0 && column < 4) : "column = " + column;
        assert (row >= 0 && row < 4) : "row = " + row;
        long matrixVa = this.va();
        double result = RMat44.getElement(matrixVa, row, column);
        return result;
    }

    @Override
    public Quat getQuaternion() {
        long matrixVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RMat44.getQuaternion(matrixVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public RVec3 getTranslation() {
        long matrixVa = this.va();
        DoubleBuffer storeDouble = Temporaries.doubleBuffer1.get();
        RMat44.getTranslation(matrixVa, storeDouble);
        RVec3 result = new RVec3(storeDouble);
        return result;
    }

    @Override
    public RMat44 inversed() {
        long currentVa = this.va();
        long resultVa = RMat44.inversed(currentVa);
        RMat44 result = new RMat44(resultVa, true);
        return result;
    }

    @Override
    public RMat44 inversedRotationTranslation() {
        long currentVa = this.va();
        long resultVa = RMat44.inversedRotationTranslation(currentVa);
        RMat44 result = new RMat44(resultVa, true);
        return result;
    }

    @Override
    public boolean isEqual(RMat44Arg m2) {
        long m1Va = this.va();
        long m2Va = m2.targetVa();
        boolean result = RMat44.equals(m1Va, m2Va);
        return result;
    }

    @Override
    public boolean isIdentity() {
        long matrixVa = this.va();
        boolean result = RMat44.isIdentity(matrixVa);
        return result;
    }

    @Override
    public RMat44 multiply(Mat44Arg right) {
        long leftVa = this.va();
        long rightVa = right.targetVa();
        long resultVa = RMat44.multiplyBySp(leftVa, rightVa);
        RMat44 result = new RMat44(resultVa, true);
        return result;
    }

    @Override
    public RMat44 multiply(RMat44Arg right) {
        long leftVa = this.va();
        long rightVa = right.targetVa();
        long productVa = RMat44.multiply(leftVa, rightVa);
        RMat44 result = new RMat44(productVa, true);
        return result;
    }

    @Override
    public Vec3 multiply3x3(Vec3Arg vec3Arg) {
        long matrixVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        vec3Arg.copyTo(floatBuffer);
        RMat44.multiply3x3(matrixVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public Vec3 multiply3x3Transposed(Vec3Arg rightVector) {
        long matrixVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        rightVector.copyTo(floatBuffer);
        RMat44.multiply3x3Transposed(matrixVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public RVec3 multiply3x4(RVec3Arg rightVector) {
        long matrixVa = this.va();
        DoubleBuffer doubleBuffer = Temporaries.doubleBuffer1.get();
        rightVector.copyTo(doubleBuffer);
        RMat44.multiply3x4r(matrixVa, doubleBuffer);
        RVec3 result = new RVec3(doubleBuffer);
        return result;
    }

    @Override
    public RVec3 multiply3x4(Vec3Arg vec3) {
        long matrixVa = this.va();
        float x = vec3.getX();
        float y = vec3.getY();
        float z = vec3.getZ();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        RMat44.multiply3x4(matrixVa, x, y, z, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public void multiply3x4InPlace(RVec3 doubleBuffer) {
        long matrixVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        doubleBuffer.copyTo(storeDoubles);
        RMat44.multiply3x4r(matrixVa, storeDoubles);
        doubleBuffer.set(storeDoubles);
    }

    @Override
    public RMat44 postTranslated(RVec3Arg leftVector) {
        long matrixVa = this.va();
        double xx = leftVector.xx();
        double yy = leftVector.yy();
        double zz = leftVector.zz();
        long resultVa = RMat44.postTranslated(matrixVa, xx, yy, zz);
        RMat44 result = new RMat44(resultVa, true);
        return result;
    }

    @Override
    public RMat44 postTranslated(Vec3Arg vec3) {
        long matrixVa = this.va();
        float x = vec3.getX();
        float y = vec3.getY();
        float z = vec3.getZ();
        long resultVa = RMat44.postTranslatedSp(matrixVa, x, y, z);
        RMat44 result = new RMat44(resultVa, true);
        return result;
    }

    @Override
    public void put3x3ColumnMajor(FloatBuffer storeFloats) {
        int position = storeFloats.position();
        long matrixVa = this.va();
        RMat44.put3x3ColumnMajor(matrixVa, position, storeFloats);
        storeFloats.position(position + 9);
    }

    @Override
    public void putColumnMajor(FloatBuffer storeFloats) {
        int position = storeFloats.position();
        long matrixVa = this.va();
        RMat44.putColumnMajor(matrixVa, position, storeFloats);
        storeFloats.position(position + 16);
    }

    @Override
    public Mat44 toMat44() {
        Mat44 result = new Mat44(this);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("RMat44[");
        for (int rowIndex = 0; rowIndex < 4; ++rowIndex) {
            result.append("\n ");
            result.append(this.getElement(rowIndex, 0));
            result.append("  ");
            result.append(this.getElement(rowIndex, 1));
            result.append("  ");
            result.append(this.getElement(rowIndex, 2));
            result.append("  ");
            result.append(this.getElement(rowIndex, 3));
        }
        result.append("\n]");
        return result.toString();
    }

    private static native void assign(long var0, long var2);

    private static native long createCopy(long var0);

    private static native long createFromRowMajor(FloatBuffer var0, double var1, double var3, double var5);

    private static native long createFromSpMatrix(long var0);

    private static native long createIdentity();

    private static native long createRotation(float var0, float var1, float var2, float var3);

    private static native long createRotationTranslation(float var0, float var1, float var2, float var3, double var4, double var6, double var8);

    private static native long createScale(float var0, float var1, float var2);

    private static native long createTranslation(double var0, double var2, double var4);

    private static native long createUninitialized();

    private static native long createZero();

    private static native boolean equals(long var0, long var2);

    private static native void free(long var0);

    private static native double getElement(long var0, int var2, int var3);

    private static native void getQuaternion(long var0, FloatBuffer var2);

    private static native void getTranslation(long var0, DoubleBuffer var2);

    private static native long inversed(long var0);

    private static native long inversedRotationTranslation(long var0);

    private static native boolean isIdentity(long var0);

    private static native void leftMultiplyInPlace(long var0, long var2);

    private static native void loadIdentity(long var0);

    private static native long multiply(long var0, long var2);

    private static native void multiply3x3(long var0, FloatBuffer var2);

    private static native void multiply3x3Transposed(long var0, FloatBuffer var2);

    private static native void multiply3x4(long var0, float var2, float var3, float var4, DoubleBuffer var5);

    private static native void multiply3x4r(long var0, DoubleBuffer var2);

    private static native long multiplyBySp(long var0, long var2);

    private static native long postTranslated(long var0, double var2, double var4, double var6);

    private static native long postTranslatedSp(long var0, float var2, float var3, float var4);

    private static native void put3x3ColumnMajor(long var0, int var2, FloatBuffer var3);

    private static native void putColumnMajor(long var0, int var2, FloatBuffer var3);

    private static native void rightMultiplyInPlace(long var0, long var2);

    private static native void setAxisX(long var0, float var2, float var3, float var4);

    private static native void setAxisY(long var0, float var2, float var3, float var4);

    private static native void setAxisZ(long var0, float var2, float var3, float var4);

    private static native void setElement(long var0, int var2, int var3, double var4);

    private static native void setTranslation(long var0, double var2, double var4, double var6);
}

