/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Rtti;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.ShapeSettings;
import com.github.stephengold.joltjni.ShapeSettingsRefC;
import com.github.stephengold.joltjni.readonly.ConstShapeSettings;
import com.github.stephengold.joltjni.template.Ref;

public final class ShapeSettingsRef
extends Ref
implements ConstShapeSettings {
    public ShapeSettingsRef() {
        long refVa = ShapeSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> ShapeSettingsRef.free(refVa));
    }

    ShapeSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> ShapeSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    @Override
    public ShapeResult create() {
        long settingsVa = this.targetVa();
        long resultVa = ShapeSettings.create(settingsVa);
        ShapeResult result = new ShapeResult(resultVa, true);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.targetVa();
        int result = ShapeSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public Rtti getRtti() {
        long jpoVa = this.targetVa();
        long resultVa = SerializableObject.getRtti(jpoVa);
        Rtti result = new Rtti(resultVa);
        return result;
    }

    @Override
    public ShapeSettingsRefC toRefC() {
        long refVa = this.va();
        long copyVa = ShapeSettingsRef.toRefC(refVa);
        ShapeSettingsRefC result = new ShapeSettingsRefC(copyVa, true);
        return result;
    }

    @Override
    public ShapeSettings getPtr() {
        long settingsVa = this.targetVa();
        ShapeSettings result = ShapeSettings.newShapeSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = ShapeSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public ShapeSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = ShapeSettingsRef.copy(refVa);
        ShapeSettingsRef result = new ShapeSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);

    private static native long toRefC(long var0);
}

