/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.SkeletalAnimation;
import com.github.stephengold.joltjni.SkeletonPose;
import com.github.stephengold.joltjni.template.Ref;

public final class SkeletalAnimationRef
extends Ref {
    public SkeletalAnimationRef() {
        long refVa = SkeletalAnimationRef.createDefault();
        this.setVirtualAddress(refVa, () -> SkeletalAnimationRef.free(refVa));
    }

    SkeletalAnimationRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> SkeletalAnimationRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public float getDuration() {
        long animationVa = this.targetVa();
        float result = SkeletalAnimation.getDuration(animationVa);
        return result;
    }

    public void sample(float time, SkeletonPose storePose) {
        long animationVa = this.targetVa();
        long poseVa = storePose.va();
        SkeletalAnimation.sample(animationVa, time, poseVa);
    }

    @Override
    public SkeletalAnimation getPtr() {
        long animationVa = this.targetVa();
        SkeletalAnimation result = new SkeletalAnimation(animationVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = SkeletalAnimationRef.getPtr(refVa);
        return result;
    }

    @Override
    public SkeletalAnimationRef toRef() {
        long refVa = this.va();
        long copyVa = SkeletalAnimationRef.copy(refVa);
        SkeletalAnimationRef result = new SkeletalAnimationRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

