/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.SoftBodyVertex;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyManifold;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyVertex;

public final class SoftBodyManifold
extends JoltPhysicsObject
implements ConstSoftBodyManifold {
    public SoftBodyManifold(long manifoldVa) {
        this.setVirtualAddress(manifoldVa);
    }

    @Override
    public int getContactBodyId(ConstSoftBodyVertex vertex) {
        long manifoldVa = this.va();
        long vertexVa = vertex.targetVa();
        int result = SoftBodyManifold.getContactBodyId(manifoldVa, vertexVa);
        return result;
    }

    @Override
    public Vec3 getContactNormal(ConstSoftBodyVertex vertex) {
        long manifoldVa = this.va();
        long vertexVa = vertex.targetVa();
        float nx = SoftBodyManifold.getLocalContactNormalX(manifoldVa, vertexVa);
        float ny = SoftBodyManifold.getLocalContactNormalY(manifoldVa, vertexVa);
        float nz = SoftBodyManifold.getLocalContactNormalZ(manifoldVa, vertexVa);
        Vec3 result = new Vec3(nx, ny, nz);
        return result;
    }

    @Override
    public Vec3 getLocalContactPoint(ConstSoftBodyVertex vertex) {
        long manifoldVa = this.va();
        long vertexVa = vertex.targetVa();
        float x = SoftBodyManifold.getLocalContactPointX(manifoldVa, vertexVa);
        float y = SoftBodyManifold.getLocalContactPointY(manifoldVa, vertexVa);
        float z = SoftBodyManifold.getLocalContactPointZ(manifoldVa, vertexVa);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public int getNumSensorContacts() {
        long manifoldVa = this.va();
        int result = SoftBodyManifold.getNumSensorContacts(manifoldVa);
        return result;
    }

    @Override
    public int getSensorContactBodyId(int index) {
        long manifoldVa = this.va();
        int result = SoftBodyManifold.getSensorContactBodyId(manifoldVa, index);
        return result;
    }

    @Override
    public ConstSoftBodyVertex[] getVertices() {
        long manifoldVa = this.va();
        int numVertices = SoftBodyManifold.countVertices(manifoldVa);
        ConstSoftBodyVertex[] result = new SoftBodyVertex[numVertices];
        SoftBodyManifold container = this.ownsNativeObject() ? this : null;
        for (int i = 0; i < numVertices; ++i) {
            long vertexVa = SoftBodyManifold.getVertex(manifoldVa, i);
            result[i] = new SoftBodyVertex(container, vertexVa);
        }
        return result;
    }

    @Override
    public boolean hasContact(ConstSoftBodyVertex vertex) {
        long manifoldVa = this.va();
        long vertexVa = vertex.targetVa();
        boolean result = SoftBodyManifold.hasContact(manifoldVa, vertexVa);
        return result;
    }

    private static native int countVertices(long var0);

    private static native int getContactBodyId(long var0, long var2);

    private static native float getLocalContactNormalX(long var0, long var2);

    private static native float getLocalContactNormalY(long var0, long var2);

    private static native float getLocalContactNormalZ(long var0, long var2);

    private static native float getLocalContactPointX(long var0, long var2);

    private static native float getLocalContactPointY(long var0, long var2);

    private static native float getLocalContactPointZ(long var0, long var2);

    private static native int getNumSensorContacts(long var0);

    private static native int getSensorContactBodyId(long var0, int var2);

    private static native long getVertex(long var0, int var2);

    private static native boolean hasContact(long var0, long var2);
}

