/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Edge;
import com.github.stephengold.joltjni.InvBind;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.RodBendTwist;
import com.github.stephengold.joltjni.RodStretchShear;
import com.github.stephengold.joltjni.SettingsResult;
import com.github.stephengold.joltjni.Skinned;
import com.github.stephengold.joltjni.SoftBodySharedSettingsRef;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Vertex;
import com.github.stephengold.joltjni.enumerate.EBendType;
import com.github.stephengold.joltjni.readonly.ConstEdge;
import com.github.stephengold.joltjni.readonly.ConstFace;
import com.github.stephengold.joltjni.readonly.ConstRodBendTwist;
import com.github.stephengold.joltjni.readonly.ConstRodStretchShear;
import com.github.stephengold.joltjni.readonly.ConstSoftBodySharedSettings;
import com.github.stephengold.joltjni.readonly.ConstVertex;
import com.github.stephengold.joltjni.readonly.ConstVertexAttributes;
import com.github.stephengold.joltjni.readonly.ConstVolume;
import com.github.stephengold.joltjni.streamutils.IdToMaterialMap;
import com.github.stephengold.joltjni.streamutils.IdToSharedSettingsMap;
import com.github.stephengold.joltjni.streamutils.MaterialToIdMap;
import com.github.stephengold.joltjni.streamutils.SharedSettingsToIdMap;
import com.github.stephengold.joltjni.template.RefTarget;
import java.nio.IntBuffer;

public class SoftBodySharedSettings
extends JoltPhysicsObject
implements ConstSoftBodySharedSettings,
RefTarget {
    public SoftBodySharedSettings() {
        long settingsVa = SoftBodySharedSettings.createDefault();
        long refVa = SoftBodySharedSettings.toRef(settingsVa);
        Runnable freeingAction = () -> SoftBodySharedSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public SoftBodySharedSettings(ConstSoftBodySharedSettings original) {
        long originalVa = original.targetVa();
        long copyVa = SoftBodySharedSettings.createCopy(originalVa);
        long refVa = SoftBodySharedSettings.toRef(copyVa);
        Runnable freeingAction = () -> SoftBodySharedSettingsRef.free(refVa);
        this.setVirtualAddress(copyVa, freeingAction);
    }

    SoftBodySharedSettings(long settingsVa) {
        long refVa = SoftBodySharedSettings.toRef(settingsVa);
        Runnable freeingAction = () -> SoftBodySharedSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public void addEdgeConstraint(ConstEdge edge) {
        long settingsVa = this.va();
        long edgeVa = edge.targetVa();
        SoftBodySharedSettings.addEdgeConstraint(settingsVa, edgeVa);
    }

    public void addFace(ConstFace face) {
        long settingsVa = this.va();
        long faceVa = face.targetVa();
        SoftBodySharedSettings.addFace(settingsVa, faceVa);
    }

    public void addInvBindMatrix(InvBind invBind) {
        long settingsVa = this.va();
        long invBindVa = invBind.va();
        SoftBodySharedSettings.addInvBindMatrix(settingsVa, invBindVa);
    }

    public void addRodBendTwistConstraint(ConstRodBendTwist constraint) {
        long settingsVa = this.va();
        long constraintVa = constraint.targetVa();
        SoftBodySharedSettings.addRodBendTwistConstraint(settingsVa, constraintVa);
    }

    public void addRodStretchShearConstraint(ConstRodStretchShear rod) {
        long settingsVa = this.va();
        long rodVa = rod.targetVa();
        SoftBodySharedSettings.addRodStretchShearConstraint(settingsVa, rodVa);
    }

    public void addSkinnedConstraint(Skinned skinned) {
        long settingsVa = this.va();
        long skinnedVa = skinned.va();
        SoftBodySharedSettings.addSkinnedConstraint(settingsVa, skinnedVa);
    }

    public void addVertex(ConstVertex vertex) {
        long settingsVa = this.va();
        long vertexVa = vertex.targetVa();
        SoftBodySharedSettings.addVertex(settingsVa, vertexVa);
    }

    public void addVolumeConstraint(ConstVolume volume) {
        long settingsVa = this.va();
        long volumeVa = volume.targetVa();
        SoftBodySharedSettings.addVolumeConstraint(settingsVa, volumeVa);
    }

    public void calculateEdgeLengths() {
        long settingsVa = this.va();
        SoftBodySharedSettings.calculateEdgeLengths(settingsVa);
    }

    public void calculateRodProperties() {
        long settingsVa = this.va();
        SoftBodySharedSettings.calculateRodProperties(settingsVa);
    }

    public void calculateSkinnedConstraintNormals() {
        long settingsVa = this.va();
        SoftBodySharedSettings.calculateSkinnedConstraintNormals(settingsVa);
    }

    public void calculateVolumeConstraintVolumes() {
        long settingsVa = this.va();
        SoftBodySharedSettings.calculateVolumeConstraintVolumes(settingsVa);
    }

    public void createConstraints(ConstVertexAttributes vertexAttributes, int numAttributes, EBendType bendType) {
        this.createConstraints(new ConstVertexAttributes[]{vertexAttributes}, bendType);
    }

    public void createConstraints(ConstVertexAttributes[] vertexAttributes, EBendType bendType) {
        this.createConstraints(vertexAttributes, bendType, Jolt.degreesToRadians(8.0f));
    }

    public void createConstraints(ConstVertexAttributes[] vertexAttributes, EBendType bendType, float angleTolerance) {
        long settingsVa = this.va();
        int numAttributes = vertexAttributes.length;
        long[] attributeVas = new long[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            attributeVas[i] = vertexAttributes[i].targetVa();
        }
        int ordinal = bendType.ordinal();
        SoftBodySharedSettings.createConstraints(settingsVa, attributeVas, ordinal, angleTolerance);
    }

    public void optimize() {
        long settingsVa = this.va();
        SoftBodySharedSettings.optimize(settingsVa);
    }

    public void restoreBinaryState(StreamIn stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        SoftBodySharedSettings.restoreBinaryState(settingsVa, streamVa);
    }

    public static SoftBodySharedSettingsRef sCreateCube(int gridSize, float gridSpacing) {
        long refVa = SoftBodySharedSettings.sCreateCubeNative(gridSize, gridSpacing);
        SoftBodySharedSettingsRef result = new SoftBodySharedSettingsRef(refVa, true);
        return result;
    }

    public void setMaterials(PhysicsMaterial material) {
        long settingsVa = this.va();
        long materialVa = material == null ? 0L : material.va();
        SoftBodySharedSettings.setMaterialsSingle(settingsVa, materialVa);
    }

    public static SettingsResult sRestoreWithMaterials(StreamIn stream, IdToSharedSettingsMap settingsMap, IdToMaterialMap materialMap) {
        long streamVa = stream.va();
        long settingsMapVa = settingsMap.va();
        long materialMapVa = materialMap.va();
        long resultVa = SoftBodySharedSettings.sRestoreWithMaterials(streamVa, settingsMapVa, materialMapVa);
        SettingsResult result = new SettingsResult(resultVa, true);
        return result;
    }

    @Override
    public int countEdgeConstraints() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.countEdgeConstraints(settingsVa);
        return result;
    }

    @Override
    public int countFaces() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.countFaces(settingsVa);
        return result;
    }

    @Override
    public int countPinnedVertices() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.countPinnedVertices(settingsVa);
        return result;
    }

    @Override
    public int countRodBendTwistConstraints() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.countRodBendTwistConstraints(settingsVa);
        return result;
    }

    @Override
    public int countRodStretchShearConstraints() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.countRodStretchShearConstraints(settingsVa);
        return result;
    }

    @Override
    public int countVertices() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.countVertices(settingsVa);
        return result;
    }

    @Override
    public int countVolumeConstraints() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.countVolumeConstraints(settingsVa);
        return result;
    }

    public Edge[] getEdgeConstraints() {
        long settingsVa = this.va();
        int numEdges = SoftBodySharedSettings.countEdgeConstraints(settingsVa);
        Edge[] result = new Edge[numEdges];
        for (int index = 0; index < numEdges; ++index) {
            long edgeVa = SoftBodySharedSettings.getEdgeConstraint(settingsVa, index);
            result[index] = new Edge(this, edgeVa);
        }
        return result;
    }

    public RodBendTwist[] getRodBendTwistConstraints() {
        long settingsVa = this.va();
        int numConstraints = SoftBodySharedSettings.countRodBendTwistConstraints(settingsVa);
        RodBendTwist[] result = new RodBendTwist[numConstraints];
        for (int index = 0; index < numConstraints; ++index) {
            long edgeVa = SoftBodySharedSettings.getRodBendTwistConstraint(settingsVa, index);
            result[index] = new RodBendTwist(this, edgeVa);
        }
        return result;
    }

    public RodStretchShear[] getRodStretchShearConstraints() {
        long settingsVa = this.va();
        int numRods = SoftBodySharedSettings.countRodBendTwistConstraints(settingsVa);
        RodStretchShear[] result = new RodStretchShear[numRods];
        for (int index = 0; index < numRods; ++index) {
            long edgeVa = SoftBodySharedSettings.getRodStretchShearConstraint(settingsVa, index);
            result[index] = new RodStretchShear(this, edgeVa);
        }
        return result;
    }

    @Override
    public Vertex getVertex(int index) {
        long settingsVa = this.va();
        long vertexVa = SoftBodySharedSettings.getVertex(settingsVa, index);
        Vertex result = new Vertex(this, vertexVa);
        return result;
    }

    public Vertex[] getVertices() {
        long settingsVa = this.va();
        int numVertices = SoftBodySharedSettings.countVertices(settingsVa);
        Vertex[] result = new Vertex[numVertices];
        for (int index = 0; index < numVertices; ++index) {
            long vertexVa = SoftBodySharedSettings.getVertex(settingsVa, index);
            result[index] = new Vertex(this, vertexVa);
        }
        return result;
    }

    @Override
    public void putEdgeIndices(IntBuffer storeIndices) {
        long settingsVa = this.va();
        int bufferPosition = storeIndices.position();
        bufferPosition = SoftBodySharedSettings.putEdgeIndices(settingsVa, bufferPosition, storeIndices);
        storeIndices.position(bufferPosition);
    }

    @Override
    public void putFaceIndices(IntBuffer storeIndices) {
        long settingsVa = this.va();
        int bufferPosition = storeIndices.position();
        bufferPosition = SoftBodySharedSettings.putFaceIndices(settingsVa, bufferPosition, storeIndices);
        storeIndices.position(bufferPosition);
    }

    @Override
    public void putRodIndices(IntBuffer storeIndices) {
        long settingsVa = this.va();
        int bufferPosition = storeIndices.position();
        bufferPosition = SoftBodySharedSettings.putRodIndices(settingsVa, bufferPosition, storeIndices);
        storeIndices.position(bufferPosition);
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        SoftBodySharedSettings.saveBinaryState(settingsVa, streamVa);
    }

    @Override
    public void saveWithMaterials(StreamOut stream, SharedSettingsToIdMap settingsMap, MaterialToIdMap materialMap) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        long settingsMapVa = settingsMap.va();
        long materialMapVa = materialMap.va();
        SoftBodySharedSettings.saveWithMaterials(settingsVa, streamVa, settingsMapVa, materialMapVa);
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = SoftBodySharedSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        SoftBodySharedSettings.setEmbedded(settingsVa);
    }

    @Override
    public SoftBodySharedSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = SoftBodySharedSettings.toRef(settingsVa);
        SoftBodySharedSettingsRef result = new SoftBodySharedSettingsRef(refVa, true);
        return result;
    }

    static native void addEdgeConstraint(long var0, long var2);

    static native void addFace(long var0, long var2);

    static native void addInvBindMatrix(long var0, long var2);

    static native void addRodBendTwistConstraint(long var0, long var2);

    static native void addRodStretchShearConstraint(long var0, long var2);

    static native void addSkinnedConstraint(long var0, long var2);

    static native void addVertex(long var0, long var2);

    static native void addVolumeConstraint(long var0, long var2);

    static native void calculateEdgeLengths(long var0);

    static native void calculateRodProperties(long var0);

    static native void calculateSkinnedConstraintNormals(long var0);

    static native void calculateVolumeConstraintVolumes(long var0);

    static native int countEdgeConstraints(long var0);

    static native int countFaces(long var0);

    static native int countPinnedVertices(long var0);

    static native int countRodBendTwistConstraints(long var0);

    static native int countRodStretchShearConstraints(long var0);

    static native int countVertices(long var0);

    static native int countVolumeConstraints(long var0);

    static native void createConstraints(long var0, long[] var2, int var3, float var4);

    private static native long createCopy(long var0);

    private static native long createDefault();

    static native long getEdgeConstraint(long var0, int var2);

    private static native int getRefCount(long var0);

    static native long getRodBendTwistConstraint(long var0, int var2);

    static native long getRodStretchShearConstraint(long var0, int var2);

    static native long getVertex(long var0, int var2);

    static native void optimize(long var0);

    static native int putEdgeIndices(long var0, int var2, IntBuffer var3);

    static native int putFaceIndices(long var0, int var2, IntBuffer var3);

    static native int putRodIndices(long var0, int var2, IntBuffer var3);

    static native void restoreBinaryState(long var0, long var2);

    static native void saveBinaryState(long var0, long var2);

    static native void saveWithMaterials(long var0, long var2, long var4, long var6);

    private static native long sCreateCubeNative(int var0, float var1);

    private static native void setEmbedded(long var0);

    static native void setMaterialsSingle(long var0, long var2);

    private static native long toRef(long var0);

    private static native long sRestoreWithMaterials(long var0, long var2, long var4);
}

