/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.VehicleControllerSettings;
import com.github.stephengold.joltjni.VehicleTrackSettings;

public class TrackedVehicleControllerSettings
extends VehicleControllerSettings {
    public TrackedVehicleControllerSettings() {
        long settingsVa = TrackedVehicleControllerSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa);
    }

    TrackedVehicleControllerSettings(long controllerSettingsVa) {
        this.setVirtualAddressAsCoOwner(controllerSettingsVa);
    }

    public TrackedVehicleControllerSettings(TrackedVehicleControllerSettings original) {
        long originalVa = original.va();
        long copyVa = TrackedVehicleControllerSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa);
    }

    public int getNumTracks() {
        long vehicleSettingsVa = this.va();
        int result = TrackedVehicleControllerSettings.getNumTracks(vehicleSettingsVa);
        return result;
    }

    public VehicleTrackSettings getTrack(int index) {
        long vehicleSettingsVa = this.va();
        long trackVa = TrackedVehicleControllerSettings.getTrack(vehicleSettingsVa, index);
        VehicleTrackSettings result = new VehicleTrackSettings(this, trackVa);
        return result;
    }

    @Override
    int controllerTypeOrdinal() {
        return 3;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native int getNumTracks(long var0);

    private static native long getTrack(long var0, int var2);
}

