/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class TriangleConvexSupport
extends JoltPhysicsObject {
    public TriangleConvexSupport(TriangleConvexSupport original) {
        long originalVa = original.va();
        long copyVa = TriangleConvexSupport.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> TriangleConvexSupport.free(copyVa));
    }

    public TriangleConvexSupport(Vec3Arg v1, Vec3Arg v2, Vec3Arg v3) {
        float v1x = v1.getX();
        float v1y = v1.getY();
        float v1z = v1.getZ();
        float v2x = v2.getX();
        float v2y = v2.getY();
        float v2z = v2.getZ();
        float v3x = v3.getX();
        float v3y = v3.getY();
        float v3z = v3.getZ();
        long triangleVa = TriangleConvexSupport.create(v1x, v1y, v1z, v2x, v2y, v2z, v3x, v3y, v3z);
        this.setVirtualAddress(triangleVa, () -> TriangleConvexSupport.free(triangleVa));
    }

    public Vec3 getV1() {
        long triangleVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TriangleConvexSupport.getVertex(triangleVa, 0, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getV2() {
        long triangleVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TriangleConvexSupport.getVertex(triangleVa, 1, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getV3() {
        long triangleVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TriangleConvexSupport.getVertex(triangleVa, 2, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long create(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private static native void free(long var0);

    private static native void getVertex(long var0, int var2, FloatBuffer var3);
}

