/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.builtin.block.BlockRenderer;
import net.xmx.velthoric.builtin.block.BlockRigidBody;
import net.xmx.velthoric.builtin.box.BoxRenderer;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.builtin.cloth.ClothRenderer;
import net.xmx.velthoric.builtin.cloth.ClothSoftBody;
import net.xmx.velthoric.builtin.drivable.car.CarImpl;
import net.xmx.velthoric.builtin.drivable.car.CarRenderer;
import net.xmx.velthoric.builtin.drivable.motorcycle.MotorcycleImpl;
import net.xmx.velthoric.builtin.drivable.motorcycle.MotorcycleRenderer;
import net.xmx.velthoric.builtin.marble.MarbleRenderer;
import net.xmx.velthoric.builtin.marble.MarbleRigidBody;
import net.xmx.velthoric.builtin.rope.RopeRenderer;
import net.xmx.velthoric.builtin.rope.RopeSoftBody;
import net.xmx.velthoric.builtin.sphere.SphereRenderer;
import net.xmx.velthoric.builtin.sphere.SphereRigidBody;
import net.xmx.velthoric.item.chaincreator.body.VxChainPartRenderer;
import net.xmx.velthoric.item.chaincreator.body.VxChainPartRigidBody;
import net.xmx.velthoric.physics.body.registry.VxBodyRegistry;
import net.xmx.velthoric.physics.body.registry.VxBodyType;

public class VxRegisteredBodies {
    public static final VxBodyType<BlockRigidBody> BLOCK = VxBodyType.Builder.create(BlockRigidBody::new).noSummon().build(new ResourceLocation("velthoric", "block"));
    public static final VxBodyType<SphereRigidBody> SPHERE = VxBodyType.Builder.create(SphereRigidBody::new).build(new ResourceLocation("velthoric", "sphere"));
    public static final VxBodyType<BoxRigidBody> BOX = VxBodyType.Builder.create(BoxRigidBody::new).build(new ResourceLocation("velthoric", "box"));
    public static final VxBodyType<MarbleRigidBody> MARBLE = VxBodyType.Builder.create(MarbleRigidBody::new).build(new ResourceLocation("velthoric", "marble"));
    public static final VxBodyType<ClothSoftBody> CLOTH = VxBodyType.Builder.create(ClothSoftBody::new).build(new ResourceLocation("velthoric", "cloth"));
    public static final VxBodyType<RopeSoftBody> ROPE = VxBodyType.Builder.create(RopeSoftBody::new).build(new ResourceLocation("velthoric", "rope"));
    public static final VxBodyType<CarImpl> CAR = VxBodyType.Builder.create(CarImpl::new).build(new ResourceLocation("velthoric", "car"));
    public static final VxBodyType<MotorcycleImpl> MOTORCYCLE = VxBodyType.Builder.create(MotorcycleImpl::new).build(new ResourceLocation("velthoric", "motorcycle"));
    public static final VxBodyType<VxChainPartRigidBody> CHAIN_PART = VxBodyType.Builder.create(VxChainPartRigidBody::new).noSummon().build(new ResourceLocation("velthoric", "chain_part"));

    public static void register() {
        VxBodyRegistry registry = VxBodyRegistry.getInstance();
        registry.register(BLOCK);
        registry.register(SPHERE);
        registry.register(BOX);
        registry.register(MARBLE);
        registry.register(CLOTH);
        registry.register(ROPE);
        registry.register(CAR);
        registry.register(MOTORCYCLE);
        registry.register(CHAIN_PART);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClientFactories() {
        VxBodyRegistry registry = VxBodyRegistry.getInstance();
        registry.registerClientFactory(BLOCK.getTypeId(), (type, id) -> new BlockRigidBody(type, id));
        registry.registerClientFactory(SPHERE.getTypeId(), (type, id) -> new SphereRigidBody(type, id));
        registry.registerClientFactory(BOX.getTypeId(), (type, id) -> new BoxRigidBody(type, id));
        registry.registerClientFactory(MARBLE.getTypeId(), (type, id) -> new MarbleRigidBody(type, id));
        registry.registerClientFactory(CLOTH.getTypeId(), (type, id) -> new ClothSoftBody(type, id));
        registry.registerClientFactory(ROPE.getTypeId(), (type, id) -> new RopeSoftBody(type, id));
        registry.registerClientFactory(CAR.getTypeId(), (type, id) -> new CarImpl(type, id));
        registry.registerClientFactory(MOTORCYCLE.getTypeId(), (type, id) -> new MotorcycleImpl(type, id));
        registry.registerClientFactory(CHAIN_PART.getTypeId(), (type, id) -> new VxChainPartRigidBody(type, id));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClientRenderers() {
        VxBodyRegistry registry = VxBodyRegistry.getInstance();
        registry.registerClientRenderer(BLOCK.getTypeId(), new BlockRenderer());
        registry.registerClientRenderer(SPHERE.getTypeId(), new SphereRenderer());
        registry.registerClientRenderer(BOX.getTypeId(), new BoxRenderer());
        registry.registerClientRenderer(MARBLE.getTypeId(), new MarbleRenderer());
        registry.registerClientRenderer(CLOTH.getTypeId(), new ClothRenderer());
        registry.registerClientRenderer(ROPE.getTypeId(), new RopeRenderer());
        registry.registerClientRenderer(CAR.getTypeId(), new CarRenderer());
        registry.registerClientRenderer(MOTORCYCLE.getTypeId(), new MotorcycleRenderer());
        registry.registerClientRenderer(CHAIN_PART.getTypeId(), new VxChainPartRenderer());
    }
}

