/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.block;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.MutableCompoundShapeSettings;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.body.util.VxVoxelShapeUtil;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class BlockRigidBody
extends VxRigidBody {
    public static final VxDataAccessor<Integer> DATA_BLOCK_STATE_ID = VxDataAccessor.create(BlockRigidBody.class, VxDataSerializers.INTEGER);

    public BlockRigidBody(VxBodyType<BlockRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRigidBody(VxBodyType<BlockRigidBody> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_BLOCK_STATE_ID, Block.m_49956_((BlockState)Blocks.f_50069_.m_49966_()));
    }

    public void setRepresentedBlockState(BlockState blockState) {
        BlockState state = blockState != null && !blockState.m_60795_() ? blockState : Blocks.f_50069_.m_49966_();
        this.setSyncData(DATA_BLOCK_STATE_ID, Block.m_49956_((BlockState)state));
    }

    public BlockState getRepresentedBlockState() {
        BlockState state = Block.m_49803_((int)this.getSyncData(DATA_BLOCK_STATE_ID));
        return !state.m_60795_() ? state : Blocks.f_50069_.m_49966_();
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        int n;
        BlockState stateForShape = this.getRepresentedBlockState();
        VoxelShape voxelShape = stateForShape.m_60812_((BlockGetter)this.physicsWorld.getLevel(), BlockPos.f_121853_);
        MutableCompoundShapeSettings shapeSettings = VxVoxelShapeUtil.toMutableCompoundShape(voxelShape);
        if (shapeSettings == null) {
            VxMainClass.LOGGER.warn("VoxelShape conversion for BlockState {} failed. Using default BoxShape.", (Object)stateForShape);
            try (MutableCompoundShapeSettings boxSettings = VxVoxelShapeUtil.toMutableCompoundShape(Blocks.f_50069_.m_49966_().m_60812_((BlockGetter)this.physicsWorld.getLevel(), BlockPos.f_121853_));){
                int n2;
                try (BodyCreationSettings bcs = new BodyCreationSettings();){
                    bcs.setMotionType(EMotionType.Dynamic);
                    bcs.setObjectLayer(1);
                    n2 = factory.create(boxSettings, bcs);
                }
                return n2;
            }
        }
        try (BodyCreationSettings bcs = new BodyCreationSettings();){
            bcs.setMotionType(EMotionType.Dynamic);
            bcs.setObjectLayer(1);
            n = factory.create(shapeSettings, bcs);
        }
        return n;
        finally {
            if (shapeSettings != null) {
                shapeSettings.close();
            }
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.m_130130_(this.getSyncData(DATA_BLOCK_STATE_ID));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        int blockStateId = buf.m_130242_();
        BlockState state = Block.m_49803_((int)blockStateId);
        if (state.m_60795_()) {
            this.setSyncData(DATA_BLOCK_STATE_ID, Block.m_49956_((BlockState)Blocks.f_50069_.m_49966_()));
        } else {
            this.setSyncData(DATA_BLOCK_STATE_ID, blockStateId);
        }
    }
}

