/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.cloth;

import com.github.stephengold.joltjni.Edge;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.SoftBodySharedSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.Vertex;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.type.VxSoftBody;
import net.xmx.velthoric.physics.body.type.factory.VxSoftBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class ClothSoftBody
extends VxSoftBody {
    public static final VxDataAccessor<Integer> DATA_WIDTH_SEGMENTS = VxDataAccessor.create(ClothSoftBody.class, VxDataSerializers.INTEGER);
    public static final VxDataAccessor<Integer> DATA_HEIGHT_SEGMENTS = VxDataAccessor.create(ClothSoftBody.class, VxDataSerializers.INTEGER);
    private float clothWidth;
    private float clothHeight;
    private float mass;
    private float compliance;

    public ClothSoftBody(VxBodyType<ClothSoftBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxSoftBody>)type, world, id);
        this.clothWidth = 2.0f;
        this.clothHeight = 2.0f;
        this.mass = 2.0f;
        this.compliance = 0.02f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClothSoftBody(VxBodyType<ClothSoftBody> type, UUID id) {
        super((VxBodyType<? extends VxSoftBody>)type, id);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_WIDTH_SEGMENTS, 15);
        this.synchronizedData.define(DATA_HEIGHT_SEGMENTS, 15);
    }

    public void setConfiguration(int widthSegments, int heightSegments, float clothWidth, float clothHeight, float mass, float compliance) {
        this.setSyncData(DATA_WIDTH_SEGMENTS, widthSegments);
        this.setSyncData(DATA_HEIGHT_SEGMENTS, heightSegments);
        this.clothWidth = clothWidth;
        this.clothHeight = clothHeight;
        this.mass = mass;
        this.compliance = compliance;
    }

    @Override
    public int createJoltBody(VxSoftBodyFactory factory) {
        int widthSegments = this.getSyncData(DATA_WIDTH_SEGMENTS);
        int heightSegments = this.getSyncData(DATA_HEIGHT_SEGMENTS);
        int numVerticesX = widthSegments + 1;
        int numVerticesY = heightSegments + 1;
        int totalVertices = numVerticesX * numVerticesY;
        try (SoftBodySharedSettings sharedSettings = new SoftBodySharedSettings();){
            int n;
            try (SoftBodyCreationSettings creationSettings = new SoftBodyCreationSettings();){
                float segmentWidth = this.clothWidth / (float)widthSegments;
                float segmentHeight = this.clothHeight / (float)heightSegments;
                float invMassPerVertex = this.mass > 0.0f ? (float)totalVertices / this.mass : 0.0f;
                Vec3[] vertexPositions = new Vec3[totalVertices];
                for (int y2 = 0; y2 < numVerticesY; ++y2) {
                    for (int x2 = 0; x2 < numVerticesX; ++x2) {
                        int index = y2 * numVerticesX + x2;
                        vertexPositions[index] = new Vec3((float)x2 * segmentWidth - this.clothWidth / 2.0f, 0.0f, (float)y2 * segmentHeight - this.clothHeight / 2.0f);
                        Vertex v = new Vertex();
                        v.setPosition(vertexPositions[index]);
                        v.setInvMass(invMassPerVertex);
                        sharedSettings.addVertex(v);
                    }
                }
                BiFunction<Integer, Integer, Integer> getIndex = (x, y) -> y * numVerticesX + x;
                for (int y3 = 0; y3 < numVerticesY; ++y3) {
                    for (int x3 = 0; x3 < numVerticesX; ++x3) {
                        if (x3 < widthSegments) {
                            this.addEdge(sharedSettings, getIndex.apply(x3, y3), getIndex.apply(x3 + 1, y3), this.compliance, vertexPositions);
                        }
                        if (y3 < heightSegments) {
                            this.addEdge(sharedSettings, getIndex.apply(x3, y3), getIndex.apply(x3, y3 + 1), this.compliance, vertexPositions);
                        }
                        if (x3 < widthSegments && y3 < heightSegments) {
                            this.addEdge(sharedSettings, getIndex.apply(x3, y3), getIndex.apply(x3 + 1, y3 + 1), this.compliance, vertexPositions);
                            this.addEdge(sharedSettings, getIndex.apply(x3 + 1, y3), getIndex.apply(x3, y3 + 1), this.compliance, vertexPositions);
                        }
                        float bendCompliance = this.compliance * 10.0f;
                        if (x3 < widthSegments - 1) {
                            this.addEdge(sharedSettings, getIndex.apply(x3, y3), getIndex.apply(x3 + 2, y3), bendCompliance, vertexPositions);
                        }
                        if (y3 >= heightSegments - 1) continue;
                        this.addEdge(sharedSettings, getIndex.apply(x3, y3), getIndex.apply(x3, y3 + 2), bendCompliance, vertexPositions);
                    }
                }
                sharedSettings.optimize();
                creationSettings.setSettings(sharedSettings);
                creationSettings.setObjectLayer(1);
                creationSettings.setVertexRadius(0.02f);
                n = factory.create(sharedSettings, creationSettings);
            }
            return n;
        }
    }

    private void addEdge(SoftBodySharedSettings settings, int v1Index, int v2Index, float edgeCompliance, Vec3[] vertexPositions) {
        Edge edge = new Edge();
        edge.setVertex(0, v1Index);
        edge.setVertex(1, v2Index);
        edge.setCompliance(edgeCompliance);
        Vec3 pos1 = vertexPositions[v1Index];
        Vec3 pos2 = vertexPositions[v2Index];
        Vec3 offset = Op.minus(pos2, (Vec3Arg)pos1);
        edge.setRestLength(offset.length());
        settings.addEdgeConstraint(edge);
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.writeInt(this.getSyncData(DATA_WIDTH_SEGMENTS));
        buf.writeInt(this.getSyncData(DATA_HEIGHT_SEGMENTS));
        buf.writeFloat(this.clothWidth);
        buf.writeFloat(this.clothHeight);
        buf.writeFloat(this.mass);
        buf.writeFloat(this.compliance);
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        this.setSyncData(DATA_WIDTH_SEGMENTS, buf.readInt());
        this.setSyncData(DATA_HEIGHT_SEGMENTS, buf.readInt());
        this.clothWidth = buf.readFloat();
        this.clothHeight = buf.readFloat();
        this.mass = buf.readFloat();
        this.compliance = buf.readFloat();
    }
}

