/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnBoxGridTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnBoxGrid";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120847_((boolean)true)).then(Commands.m_82129_((String)"gridSizeX", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"gridSizeY", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"gridSizeZ", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"boxSize", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(Commands.m_82129_((String)"spacing", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(this::executeGridWithSpacing)))))));
    }

    private int executeGridWithSpacing(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel serverLevel = source.m_81372_();
        net.minecraft.world.phys.Vec3 initialPos = Vec3Argument.m_120844_(context, (String)"position");
        int gridSizeX = IntegerArgumentType.getInteger(context, (String)"gridSizeX");
        int gridSizeY = IntegerArgumentType.getInteger(context, (String)"gridSizeY");
        int gridSizeZ = IntegerArgumentType.getInteger(context, (String)"gridSizeZ");
        float boxSize = FloatArgumentType.getFloat(context, (String)"boxSize");
        float spacing = FloatArgumentType.getFloat(context, (String)"spacing");
        int spawnedCount = 0;
        float halfExtent = boxSize / 2.0f;
        Vec3 halfExtents = new Vec3(halfExtent, halfExtent, halfExtent);
        float step = boxSize + spacing;
        for (int i = 0; i < gridSizeX; ++i) {
            for (int j = 0; j < gridSizeY; ++j) {
                for (int k = 0; k < gridSizeZ; ++k) {
                    double x = initialPos.f_82479_ + (double)((float)i * step);
                    double y = initialPos.f_82480_ + (double)((float)j * step);
                    double z = initialPos.f_82481_ + (double)((float)k * step);
                    if (this.spawn(serverLevel, new net.minecraft.world.phys.Vec3(x, y, z), halfExtents) != 1) continue;
                    ++spawnedCount;
                }
            }
        }
        int finalSpawnedCount = spawnedCount;
        source.m_288197_(() -> Component.m_237113_((String)String.format("Successfully spawned %d boxes in a %dx%dx%d grid with spacing %.2f.", finalSpawnedCount, gridSizeX, gridSizeY, gridSizeZ, Float.valueOf(spacing))), true);
        return spawnedCount;
    }

    private int spawn(ServerLevel serverLevel, net.minecraft.world.phys.Vec3 spawnPosMc, Vec3 halfExtents) {
        VxTransform transform;
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)serverLevel.m_46472_());
        if (physicsWorld == null) {
            return 0;
        }
        VxBodyManager manager = physicsWorld.getBodyManager();
        BoxRigidBody spawnedBody = manager.createRigidBody(VxRegisteredBodies.BOX, transform = new VxTransform(new RVec3(spawnPosMc.f_82479_, spawnPosMc.f_82480_, spawnPosMc.f_82481_), Quat.sIdentity()), box -> box.setHalfExtents(halfExtents));
        return spawnedBody != null ? 1 : 0;
    }
}

