/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.debug;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.xmx.velthoric.mixin.impl.misc.accessor.MixinDebugScreenOverlayAccessor;

public class VxPhysicsDebugChart {
    public static void draw(GuiGraphics guiGraphics, MixinDebugScreenOverlayAccessor accessor, FrameTimer frameTimer, int x, int width, int baseY) {
        Font font = accessor.getFont();
        int logStart = frameTimer.m_13754_();
        int logEnd = frameTimer.m_13761_();
        long[] log = frameTimer.m_13764_();
        int dataLength = log.length - Math.max(0, log.length - width);
        int logIndex = frameTimer.m_13762_(logStart + Math.max(0, log.length - width));
        long totalTime = 0L;
        int minTime = Integer.MAX_VALUE;
        int maxTime = Integer.MIN_VALUE;
        for (int i = 0; i < dataLength; ++i) {
            int timeMs = (int)(log[frameTimer.m_13762_(logIndex + i)] / 1000000L);
            minTime = Math.min(minTime, timeMs);
            maxTime = Math.max(maxTime, timeMs);
            totalTime += (long)timeMs;
        }
        guiGraphics.m_285944_(RenderType.m_286086_(), x, baseY - 60, x + dataLength, baseY, -1873784752);
        int currentX = x;
        while (logIndex != logEnd) {
            int scaledHeight = frameTimer.m_13757_(log[logIndex], 30, 60);
            int color = accessor.invokeGetSampleColor(Mth.m_14045_((int)scaledHeight, (int)0, (int)60), 0, 30, 60);
            guiGraphics.m_285944_(RenderType.m_286086_(), currentX, baseY - scaledHeight, currentX + 1, baseY, color);
            ++currentX;
            logIndex = frameTimer.m_13762_(logIndex + 1);
        }
        guiGraphics.m_285844_(RenderType.m_286086_(), x, x + dataLength - 1, baseY - 60, -1);
        guiGraphics.m_285844_(RenderType.m_286086_(), x, x + dataLength - 1, baseY - 1, -1);
        guiGraphics.m_285886_(RenderType.m_286086_(), x, baseY - 60, baseY, -1);
        guiGraphics.m_285886_(RenderType.m_286086_(), x + dataLength - 1, baseY - 60, baseY, -1);
        guiGraphics.m_285944_(RenderType.m_286086_(), x + 1, baseY - 60 + 1, x + 40, baseY - 60 + 10, -1873784752);
        guiGraphics.m_280056_(font, "Physics", x + 2, baseY - 60 + 2, 0xE0E0E0, false);
        String minText = minTime + " ms min";
        String avgText = (dataLength > 0 ? totalTime / (long)dataLength : 0L) + " ms avg";
        String maxText = maxTime + " ms max";
        guiGraphics.m_280056_(font, minText, x + 2, baseY - 60 - 9, 0xE0E0E0, false);
        guiGraphics.m_280137_(font, avgText, x + dataLength / 2, baseY - 60 - 9, 0xE0E0E0);
        guiGraphics.m_280488_(font, maxText, x + dataLength - font.m_92895_(maxText), baseY - 60 - 9, 0xE0E0E0);
    }
}

