/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.chaincreator.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.xmx.velthoric.item.chaincreator.VxChainCreatorManager;

public class VxChainCreatorActionPacket {
    private final ActionType actionType;

    public VxChainCreatorActionPacket(ActionType actionType) {
        this.actionType = actionType;
    }

    public static void encode(VxChainCreatorActionPacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.actionType);
    }

    public static VxChainCreatorActionPacket decode(FriendlyByteBuf buf) {
        return new VxChainCreatorActionPacket((ActionType)buf.m_130066_(ActionType.class));
    }

    public static void handle(VxChainCreatorActionPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            VxChainCreatorManager manager = VxChainCreatorManager.INSTANCE;
            switch (msg.actionType) {
                case START_CREATION: {
                    manager.startChainCreation(player);
                    break;
                }
                case FINISH_CREATION: {
                    manager.finishChainCreation(player);
                }
            }
        });
    }

    public static enum ActionType {
        START_CREATION,
        FINISH_CREATION;

    }
}

