/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.event;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.xmx.velthoric.init.registry.ItemRegistry;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunServerManager;

public class VxPhysicsGunEvents {
    public static void registerEvents() {
        TickEvent.SERVER_POST.register(VxPhysicsGunEvents::onServerPostTick);
        PlayerEvent.PLAYER_JOIN.register(VxPhysicsGunEvents::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(VxPhysicsGunEvents::onPlayerQuit);
    }

    private static void onServerPostTick(MinecraftServer server) {
        VxPhysicsGunServerManager manager = VxPhysicsGunServerManager.getInstance();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            boolean isHoldingGun;
            boolean bl = isHoldingGun = player.m_21205_().m_150930_((Item)ItemRegistry.PHYSICS_GUN.get()) || player.m_21206_().m_150930_((Item)ItemRegistry.PHYSICS_GUN.get());
            if (isHoldingGun) {
                if (manager.isGrabbing((Player)player)) {
                    manager.serverTick(player);
                    continue;
                }
                if (!manager.isTryingToGrab((Player)player)) continue;
                manager.startGrab(player);
                continue;
            }
            if (!manager.isTryingToGrab((Player)player) && !manager.isGrabbing((Player)player)) continue;
            manager.stopGrabAttempt(player);
        }
    }

    private static void onPlayerJoin(ServerPlayer newPlayer) {
        VxPhysicsGunServerManager.getInstance().syncStateForNewPlayer(newPlayer);
    }

    private static void onPlayerQuit(ServerPlayer player) {
        VxPhysicsGunServerManager.getInstance().stopGrabAttempt(player);
    }
}

