/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.manager;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunActionPacket;
import net.xmx.velthoric.network.VxPacketHandler;

public class VxPhysicsGunClientManager {
    private static final VxPhysicsGunClientManager INSTANCE = new VxPhysicsGunClientManager();
    private final Map<UUID, ClientGrabData> activeGrabs = new ConcurrentHashMap<UUID, ClientGrabData>();
    private final Set<UUID> playersTryingToGrab = ConcurrentHashMap.newKeySet();
    private boolean rotationMode = false;

    private VxPhysicsGunClientManager() {
    }

    public static VxPhysicsGunClientManager getInstance() {
        return INSTANCE;
    }

    public void startGrabAttempt() {
        VxPacketHandler.sendToServer(new VxPhysicsGunActionPacket(VxPhysicsGunActionPacket.ActionType.START_GRAB_ATTEMPT));
    }

    public void stopGrabAttempt() {
        VxPacketHandler.sendToServer(new VxPhysicsGunActionPacket(VxPhysicsGunActionPacket.ActionType.STOP_GRAB_ATTEMPT));
        this.setRotationMode(false);
    }

    public void updateState(Map<UUID, ClientGrabData> newActiveGrabs, Set<UUID> newPlayersTryingToGrab) {
        this.activeGrabs.clear();
        this.activeGrabs.putAll(newActiveGrabs);
        this.playersTryingToGrab.clear();
        this.playersTryingToGrab.addAll(newPlayersTryingToGrab);
    }

    public boolean isGrabbing(Player player) {
        return this.activeGrabs.containsKey(player.m_20148_());
    }

    public boolean isTryingToGrab(Player player) {
        return this.playersTryingToGrab.contains(player.m_20148_());
    }

    public Map<UUID, ClientGrabData> getActiveGrabs() {
        return this.activeGrabs;
    }

    public Set<UUID> getPlayersTryingToGrab() {
        return this.playersTryingToGrab;
    }

    public boolean isRotationMode() {
        return this.rotationMode;
    }

    public void setRotationMode(boolean active) {
        this.rotationMode = active;
    }

    public record ClientGrabData(UUID objectUuid, Vec3 localHitPoint) {
    }
}

