/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.math;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import java.util.Optional;
import net.minecraft.world.phys.AABB;
import net.xmx.velthoric.math.VxTransform;

public class VxOBB {
    private static final double EPSILON = 1.0E-7;
    public final VxTransform transform;
    public final AABB localAABB;

    public VxOBB(VxTransform transform, AABB localAABB) {
        this.transform = transform.copy();
        this.localAABB = localAABB;
    }

    public VxOBB(VxTransform transform, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.transform = transform.copy();
        this.localAABB = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static VxOBB ofSize(VxTransform transform, net.minecraft.world.phys.Vec3 center, double xSize, double ySize, double zSize) {
        AABB local = new AABB(-xSize / 2.0, -ySize / 2.0, -zSize / 2.0, xSize / 2.0, ySize / 2.0, zSize / 2.0);
        VxTransform newTransform = transform.copy();
        newTransform.getTranslation().set(center.f_82479_, center.f_82480_, center.f_82481_);
        return new VxOBB(newTransform, local);
    }

    public net.minecraft.world.phys.Vec3 getCenter() {
        RVec3 center = this.transform.getTranslation();
        return new net.minecraft.world.phys.Vec3(center.xx(), center.yy(), center.zz());
    }

    public net.minecraft.world.phys.Vec3 getExtents() {
        return new net.minecraft.world.phys.Vec3(this.localAABB.m_82362_() / 2.0, this.localAABB.m_82376_() / 2.0, this.localAABB.m_82385_() / 2.0);
    }

    public VxOBB move(double x, double y, double z) {
        VxTransform newTransform = this.transform.copy();
        RVec3 translation = newTransform.getTranslation();
        translation.set(translation.xx() + x, translation.yy() + y, translation.zz() + z);
        return new VxOBB(newTransform, this.localAABB);
    }

    public VxOBB move(net.minecraft.world.phys.Vec3 vec) {
        return this.move(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public VxOBB rotate(Quat rotation) {
        VxTransform newTransform = this.transform.copy();
        Quat resultRotation = Op.star((QuatArg)newTransform.getRotation(), (QuatArg)rotation);
        newTransform.getRotation().set(resultRotation);
        return new VxOBB(newTransform, this.localAABB);
    }

    public VxOBB inflate(double value) {
        return new VxOBB(this.transform, this.localAABB.m_82400_(value));
    }

    public VxOBB inflate(double x, double y, double z) {
        return new VxOBB(this.transform, this.localAABB.m_82377_(x, y, z));
    }

    public VxOBB deflate(double value) {
        return new VxOBB(this.transform, this.localAABB.m_82406_(value));
    }

    public boolean contains(net.minecraft.world.phys.Vec3 point) {
        net.minecraft.world.phys.Vec3 localPoint = this.transformToLocal(point);
        return this.localAABB.m_82390_(localPoint);
    }

    public boolean intersects(VxOBB other) {
        double rb;
        int i;
        net.minecraft.world.phys.Vec3 extentsA = this.getExtents();
        Quat rotA = this.transform.getRotation();
        net.minecraft.world.phys.Vec3[] axesA = new net.minecraft.world.phys.Vec3[]{VxOBB.toMcVec3(rotA.rotateAxisX()), VxOBB.toMcVec3(rotA.rotateAxisY()), VxOBB.toMcVec3(rotA.rotateAxisZ())};
        net.minecraft.world.phys.Vec3 extentsB = other.getExtents();
        Quat rotB = other.transform.getRotation();
        net.minecraft.world.phys.Vec3[] axesB = new net.minecraft.world.phys.Vec3[]{VxOBB.toMcVec3(rotB.rotateAxisX()), VxOBB.toMcVec3(rotB.rotateAxisY()), VxOBB.toMcVec3(rotB.rotateAxisZ())};
        net.minecraft.world.phys.Vec3 t = other.getCenter().m_82546_(this.getCenter());
        double[][] R = new double[3][3];
        double[][] absR = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i][j] = axesA[i].m_82526_(axesB[j]);
                absR[i][j] = Math.abs(R[i][j]) + 1.0E-7;
            }
        }
        for (i = 0; i < 3; ++i) {
            double ra = VxOBB.getComponent(extentsA, i);
            rb = VxOBB.getComponent(extentsB, 0) * absR[i][0] + VxOBB.getComponent(extentsB, 1) * absR[i][1] + VxOBB.getComponent(extentsB, 2) * absR[i][2];
            if (!(Math.abs(axesA[i].m_82526_(t)) > ra + rb)) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            double ra = VxOBB.getComponent(extentsA, 0) * absR[0][i] + VxOBB.getComponent(extentsA, 1) * absR[1][i] + VxOBB.getComponent(extentsA, 2) * absR[2][i];
            rb = VxOBB.getComponent(extentsB, i);
            double projection = axesB[i].m_82526_(t);
            if (!(Math.abs(projection) > ra + rb)) continue;
            return false;
        }
        double ra = extentsA.f_82480_ * absR[2][0] + extentsA.f_82481_ * absR[1][0];
        double rb2 = extentsB.f_82480_ * absR[0][2] + extentsB.f_82481_ * absR[0][1];
        if (Math.abs(t.f_82481_ * R[1][0] - t.f_82480_ * R[2][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82480_ * absR[2][1] + extentsA.f_82481_ * absR[1][1];
        rb2 = extentsB.f_82479_ * absR[0][2] + extentsB.f_82481_ * absR[0][0];
        if (Math.abs(t.f_82481_ * R[1][1] - t.f_82480_ * R[2][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82480_ * absR[2][2] + extentsA.f_82481_ * absR[1][2];
        rb2 = extentsB.f_82479_ * absR[0][1] + extentsB.f_82480_ * absR[0][0];
        if (Math.abs(t.f_82481_ * R[1][2] - t.f_82480_ * R[2][2]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82479_ * absR[2][0] + extentsA.f_82481_ * absR[0][0];
        rb2 = extentsB.f_82480_ * absR[1][2] + extentsB.f_82481_ * absR[1][1];
        if (Math.abs(t.f_82479_ * R[2][0] - t.f_82481_ * R[0][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82479_ * absR[2][1] + extentsA.f_82481_ * absR[0][1];
        rb2 = extentsB.f_82479_ * absR[1][2] + extentsB.f_82481_ * absR[1][0];
        if (Math.abs(t.f_82479_ * R[2][1] - t.f_82481_ * R[0][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82479_ * absR[2][2] + extentsA.f_82481_ * absR[0][2];
        rb2 = extentsB.f_82479_ * absR[1][1] + extentsB.f_82480_ * absR[1][0];
        if (Math.abs(t.f_82479_ * R[2][2] - t.f_82481_ * R[0][2]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82479_ * absR[1][0] + extentsA.f_82480_ * absR[0][0];
        rb2 = extentsB.f_82480_ * absR[2][2] + extentsB.f_82481_ * absR[2][1];
        if (Math.abs(t.f_82480_ * R[0][0] - t.f_82479_ * R[1][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82479_ * absR[1][1] + extentsA.f_82480_ * absR[0][1];
        rb2 = extentsB.f_82479_ * absR[2][2] + extentsB.f_82481_ * absR[2][0];
        if (Math.abs(t.f_82480_ * R[0][1] - t.f_82479_ * R[1][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.f_82479_ * absR[1][2] + extentsA.f_82480_ * absR[0][2];
        rb2 = extentsB.f_82479_ * absR[2][1] + extentsB.f_82480_ * absR[2][0];
        return !(Math.abs(t.f_82480_ * R[0][2] - t.f_82479_ * R[1][2]) > ra + rb2);
    }

    public boolean intersectsWith(AABB aabb) {
        net.minecraft.world.phys.Vec3 center = aabb.m_82399_();
        double hx = aabb.m_82362_() / 2.0;
        double hy = aabb.m_82376_() / 2.0;
        double hz = aabb.m_82385_() / 2.0;
        VxTransform aabbTransform = new VxTransform(new RVec3(center.f_82479_, center.f_82480_, center.f_82481_), new Quat());
        AABB localAABB = new AABB(-hx, -hy, -hz, hx, hy, hz);
        VxOBB other = new VxOBB(aabbTransform, localAABB);
        return this.intersects(other);
    }

    public Optional<net.minecraft.world.phys.Vec3> clip(net.minecraft.world.phys.Vec3 from, net.minecraft.world.phys.Vec3 to) {
        net.minecraft.world.phys.Vec3 localFrom = this.transformToLocal(from);
        net.minecraft.world.phys.Vec3 localTo = this.transformToLocal(to);
        Optional localHit = this.localAABB.m_82371_(localFrom, localTo);
        return localHit.map(this::transformToWorld);
    }

    public AABB getBounds() {
        net.minecraft.world.phys.Vec3[] corners = this.getCorners();
        net.minecraft.world.phys.Vec3 min = corners[0];
        net.minecraft.world.phys.Vec3 max = corners[0];
        for (int i = 1; i < 8; ++i) {
            min = new net.minecraft.world.phys.Vec3(Math.min(min.f_82479_, corners[i].f_82479_), Math.min(min.f_82480_, corners[i].f_82480_), Math.min(min.f_82481_, corners[i].f_82481_));
            max = new net.minecraft.world.phys.Vec3(Math.max(max.f_82479_, corners[i].f_82479_), Math.max(max.f_82480_, corners[i].f_82480_), Math.max(max.f_82481_, corners[i].f_82481_));
        }
        return new AABB(min, max);
    }

    public net.minecraft.world.phys.Vec3[] getCorners() {
        net.minecraft.world.phys.Vec3[] corners = new net.minecraft.world.phys.Vec3[]{this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82288_, this.localAABB.f_82289_, this.localAABB.f_82290_)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82291_, this.localAABB.f_82289_, this.localAABB.f_82290_)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82291_, this.localAABB.f_82292_, this.localAABB.f_82290_)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82288_, this.localAABB.f_82292_, this.localAABB.f_82290_)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82288_, this.localAABB.f_82289_, this.localAABB.f_82293_)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82291_, this.localAABB.f_82289_, this.localAABB.f_82293_)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82291_, this.localAABB.f_82292_, this.localAABB.f_82293_)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.f_82288_, this.localAABB.f_82292_, this.localAABB.f_82293_))};
        return corners;
    }

    private net.minecraft.world.phys.Vec3 transformToLocal(net.minecraft.world.phys.Vec3 worldPoint) {
        RVec3 center = this.transform.getTranslation();
        RVec3 p = new RVec3(worldPoint.f_82479_ - center.xx(), worldPoint.f_82480_ - center.yy(), worldPoint.f_82481_ - center.zz());
        Quat inverseRotation = this.transform.getRotation().conjugated();
        RVec3 localPoint = new RVec3(p);
        localPoint.rotateInPlace(inverseRotation);
        return new net.minecraft.world.phys.Vec3(localPoint.xx(), localPoint.yy(), localPoint.zz());
    }

    private net.minecraft.world.phys.Vec3 transformToWorld(net.minecraft.world.phys.Vec3 localPoint) {
        RVec3 p = new RVec3(localPoint.f_82479_, localPoint.f_82480_, localPoint.f_82481_);
        RVec3 rotatedPoint = new RVec3(p);
        rotatedPoint.rotateInPlace(this.transform.getRotation());
        RVec3 center = this.transform.getTranslation();
        return new net.minecraft.world.phys.Vec3(rotatedPoint.xx() + center.xx(), rotatedPoint.yy() + center.yy(), rotatedPoint.zz() + center.zz());
    }

    private static net.minecraft.world.phys.Vec3 toMcVec3(Vec3 joltVec) {
        return new net.minecraft.world.phys.Vec3((double)joltVec.getX(), (double)joltVec.getY(), (double)joltVec.getZ());
    }

    private static double getComponent(net.minecraft.world.phys.Vec3 v, int index) {
        return switch (index) {
            case 0 -> v.f_82479_;
            case 1 -> v.f_82480_;
            case 2 -> v.f_82481_;
            default -> 0.0;
        };
    }

    public String toString() {
        return "VxOBB{transform=" + String.valueOf(this.transform) + ", localAABB=" + String.valueOf(this.localAABB) + "}";
    }
}

