/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.event.chunk;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.xmx.velthoric.event.api.VxChunkEvent;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class})
public class MixinChunkMap_VxChunkEvent {
    @Shadow
    @Final
    ServerLevel f_140133_;

    @Inject(method={"protoChunkToFullChunk"}, at={@At(value="RETURN")}, cancellable=true)
    private void onProtoChunkToFullChunk(ChunkHolder holder, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        CompletableFuture originalFuture = (CompletableFuture)cir.getReturnValue();
        CompletionStage newFuture = originalFuture.thenApply(either -> {
            either.ifLeft(chunkAccess -> {
                if (chunkAccess instanceof LevelChunk) {
                    LevelChunk levelChunk = (LevelChunk)chunkAccess;
                    ((VxChunkEvent.Load.Listener)VxChunkEvent.Load.EVENT.invoker()).onChunkLoad(new VxChunkEvent.Load(levelChunk));
                }
            });
            return either;
        });
        cir.setReturnValue((Object)newFuture);
    }

    @Inject(method={"scheduleUnload"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenAcceptAsync(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private void onScheduleUnload(long chunkPos, ChunkHolder chunkHolder, CallbackInfo ci) {
        CompletableFuture future = chunkHolder.m_140090_();
        future.thenAcceptAsync(chunkAccess -> {
            if (chunkAccess instanceof LevelChunk) {
                LevelChunk levelChunk = (LevelChunk)chunkAccess;
                this.f_140133_.m_7654_().execute(() -> ((VxChunkEvent.Unload.Listener)VxChunkEvent.Unload.EVENT.invoker()).onChunkUnload(new VxChunkEvent.Unload(levelChunk)));
            }
        }, (Executor)this.f_140133_.m_7654_());
    }

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")})
    private void onUpdateChunkTracking(ServerPlayer player, ChunkPos pos, MutableObject<?> packetRef, boolean watch, boolean currentlyWatching, CallbackInfo ci) {
        LevelChunk chunk = this.f_140133_.m_7726_().m_7131_(pos.f_45578_, pos.f_45579_);
        if (chunk != null) {
            if (watch && !currentlyWatching) {
                ((VxChunkEvent.Watch.Listener)VxChunkEvent.Watch.EVENT.invoker()).onChunkWatch(new VxChunkEvent.Watch(chunk, player));
            } else if (!watch && currentlyWatching) {
                ((VxChunkEvent.Unwatch.Listener)VxChunkEvent.Unwatch.EVENT.invoker()).onChunkUnwatch(new VxChunkEvent.Unwatch(chunk, player));
            }
        }
    }
}

