/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.entity;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyInterpolator;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Shadow
    private Level f_19853_;
    @Unique
    private static final RVec3 velthoric_interpolatedPosition = new RVec3();
    @Unique
    private static final Quat velthoric_interpolatedRotation = new Quat();

    @Shadow
    public abstract float m_20192_();

    @Shadow
    public abstract Entity m_20202_();

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_getEyePositionOnPhysicsBody(float partialTicks, CallbackInfoReturnable<Vec3> cir) {
        if (!this.f_19853_.m_5776_()) {
            return;
        }
        Entity entity = this.m_20202_();
        if (entity instanceof VxMountingEntity) {
            VxMountingEntity proxy = (VxMountingEntity)entity;
            proxy.getPhysicsBodyId().ifPresent(id -> {
                VxClientBodyManager manager = VxClientBodyManager.getInstance();
                VxClientBodyDataStore store = manager.getStore();
                VxClientBodyInterpolator interpolator = manager.getInterpolator();
                Integer index = store.getIndexForId((UUID)id);
                if (index == null || !store.render_isInitialized[index]) {
                    return;
                }
                interpolator.interpolateFrame(store, index, partialTicks, velthoric_interpolatedPosition, velthoric_interpolatedRotation);
                Quaterniond physRotation = new Quaterniond((double)velthoric_interpolatedRotation.getX(), (double)velthoric_interpolatedRotation.getY(), (double)velthoric_interpolatedRotation.getZ(), (double)velthoric_interpolatedRotation.getW());
                Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
                physRotation.transform(rideOffset);
                Vector3d playerBasePos = new Vector3d(velthoric_interpolatedPosition.xx(), velthoric_interpolatedPosition.yy(), velthoric_interpolatedPosition.zz()).add((double)rideOffset.x(), (double)rideOffset.y(), (double)rideOffset.z());
                Vector3d eyeOffset = new Vector3d(0.0, (double)this.m_20192_(), 0.0);
                physRotation.transform(eyeOffset);
                Vector3d finalEyePos = playerBasePos.add((Vector3dc)eyeOffset);
                cir.setReturnValue((Object)new Vec3(finalEyePos.x, finalEyePos.y, finalEyePos.z));
            });
        }
    }

    @Inject(method={"calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void velthoric_transformViewVector(float xRot, float yRot, CallbackInfoReturnable<Vec3> cir) {
        Entity self = (Entity)this;
        Entity entity = self.m_20202_();
        if (!(entity instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)entity;
        proxy.getPhysicsBodyId().ifPresent(id -> {
            Quaterniond vehicleRotation;
            Vec3 localViewVector = (Vec3)cir.getReturnValue();
            Vector3d transformedVector = new Vector3d(localViewVector.f_82479_, localViewVector.f_82480_, localViewVector.f_82481_);
            if (this.f_19853_.m_5776_()) {
                vehicleRotation = this.velthoric_getClientRotation((UUID)id);
                if (vehicleRotation == null) {
                    return;
                }
            } else {
                VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.f_19853_.m_46472_());
                if (physicsWorld == null) {
                    return;
                }
                VxBody body = physicsWorld.getBodyManager().getVxBody((UUID)id);
                if (body == null) {
                    return;
                }
                Quat rot = body.getTransform().getRotation();
                vehicleRotation = new Quaterniond((double)rot.getX(), (double)rot.getY(), (double)rot.getZ(), (double)rot.getW());
            }
            vehicleRotation.transform(transformedVector);
            cir.setReturnValue((Object)new Vec3(transformedVector.x, transformedVector.y, transformedVector.z));
        });
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private Quaterniond velthoric_getClientRotation(UUID id) {
        VxClientBodyManager manager = VxClientBodyManager.getInstance();
        VxClientBodyDataStore store = manager.getStore();
        Integer index = store.getIndexForId(id);
        if (index == null || !store.render_isInitialized[index]) {
            return null;
        }
        float partialTicks = this.velthoric_getPartialTicksClient();
        manager.getInterpolator().interpolateRotation(store, index, partialTicks, velthoric_interpolatedRotation);
        return new Quaterniond((double)velthoric_interpolatedRotation.getX(), (double)velthoric_interpolatedRotation.getY(), (double)velthoric_interpolatedRotation.getZ(), (double)velthoric_interpolatedRotation.getW());
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private float velthoric_getPartialTicksClient() {
        return Minecraft.m_91087_().m_91296_();
    }
}

