/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.github.stephengold.joltjni.Quat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyInterpolator;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class MixinEntityRenderDispatcher {
    @Unique
    private static final Quat velthoric_tempRenderRot = new Quat();

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderer;render(Lnet/minecraft/world/entity/Entity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", shift=At.Shift.BEFORE)})
    private <E extends Entity> void velthoric_applyFullEntityTransform(E entity, double x, double y, double z, float rotationYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof VxMountingEntity) {
            VxMountingEntity proxy = (VxMountingEntity)entity2;
            proxy.getPhysicsBodyId().ifPresent(id -> {
                VxClientBodyManager manager = VxClientBodyManager.getInstance();
                VxClientBodyDataStore store = manager.getStore();
                VxClientBodyInterpolator interpolator = manager.getInterpolator();
                Integer index = store.getIndexForId((UUID)id);
                if (index == null || !store.render_isInitialized[index]) {
                    return;
                }
                interpolator.interpolateRotation(store, index, partialTicks, velthoric_tempRenderRot);
                Quaternionf physRotation = new Quaternionf(velthoric_tempRenderRot.getX(), velthoric_tempRenderRot.getY(), velthoric_tempRenderRot.getZ(), velthoric_tempRenderRot.getW());
                poseStack.m_252781_(physRotation);
            });
        }
    }

    @Redirect(method={"renderHitbox"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 velthoric_redirectViewVectorForHitbox(Entity instance, float partialTicks) {
        Vec3 originalViewVector = instance.m_20252_(partialTicks);
        Entity entity = instance.m_20202_();
        if (entity instanceof VxMountingEntity) {
            VxMountingEntity proxy = (VxMountingEntity)entity;
            return proxy.getPhysicsBodyId().map(id -> {
                VxClientBodyManager manager = VxClientBodyManager.getInstance();
                VxClientBodyDataStore store = manager.getStore();
                VxClientBodyInterpolator interpolator = manager.getInterpolator();
                Integer index = store.getIndexForId((UUID)id);
                if (index == null || !store.render_isInitialized[index]) {
                    return originalViewVector;
                }
                interpolator.interpolateRotation(store, index, partialTicks, velthoric_tempRenderRot);
                Quaterniond physRotation = new Quaterniond((double)velthoric_tempRenderRot.getX(), (double)velthoric_tempRenderRot.getY(), (double)velthoric_tempRenderRot.getZ(), (double)velthoric_tempRenderRot.getW());
                physRotation.invert();
                Vector3d correctedVector = new Vector3d(originalViewVector.f_82479_, originalViewVector.f_82480_, originalViewVector.f_82481_);
                physRotation.transform(correctedVector);
                return new Vec3(correctedVector.x, correctedVector.y, correctedVector.z);
            }).orElse(originalViewVector);
        }
        return originalViewVector;
    }
}

