/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.github.stephengold.joltjni.Quat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class MixinEntityRenderer {
    @Unique
    private static final Quat velthoric_tempRenderRot = new Quat();

    @Inject(method={"renderNameTag"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=0)})
    private <T extends Entity> void velthoric_invertPhysicsRotationBeforeCameraOrientation(T entity, Component displayName, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        Entity entity2 = entity.m_20202_();
        if (!(entity2 instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)entity2;
        proxy.getPhysicsBodyId().ifPresent(id -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                return;
            }
            float partialTicks = Minecraft.m_91087_().m_91296_();
            manager.getInterpolator().interpolateRotation(store, index, partialTicks, velthoric_tempRenderRot);
            Quaternionf physRotation = new Quaternionf(velthoric_tempRenderRot.getX(), velthoric_tempRenderRot.getY(), velthoric_tempRenderRot.getZ(), velthoric_tempRenderRot.getW());
            physRotation.conjugate();
            poseStack.m_252781_(physRotation);
        });
    }
}

