/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntityState;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    Minecraft f_109059_;
    @Shadow
    @Final
    private Camera f_109054_;
    @Unique
    private final RVec3 velthoric_interpolatedPosition = new RVec3();
    @Unique
    private final Quat velthoric_interpolatedRotation = new Quat();
    @Unique
    private final Map<Integer, VxMountingEntityState> velthoric_originalStates = new HashMap<Integer, VxMountingEntityState>();

    @Shadow
    protected abstract double m_109141_(Camera var1, float var2, boolean var3);

    @Shadow
    public abstract Matrix4f m_253088_(double var1);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.BEFORE)})
    private void velthoric_preRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.clear();
        for (Entity entity : clientWorld.m_104735_()) {
            Entity passenger;
            VxMountingEntity proxy;
            if (!(entity instanceof VxMountingEntity) || (proxy = (VxMountingEntity)entity).m_20197_().isEmpty() || (passenger = proxy.m_146895_()) == null) continue;
            this.velthoric_adjustEntityForRender(proxy, tickDelta);
            this.velthoric_adjustEntityForRender(passenger, tickDelta);
        }
    }

    @Unique
    private void velthoric_adjustEntityForRender(Entity entity, float tickDelta) {
        VxMountingEntity proxy;
        Entity vehicle = entity.m_20202_();
        if (vehicle instanceof VxMountingEntity) {
            VxMountingEntity vehicleProxy;
            proxy = vehicleProxy = (VxMountingEntity)vehicle;
        } else if (entity instanceof VxMountingEntity) {
            VxMountingEntity selfProxy;
            proxy = selfProxy = (VxMountingEntity)entity;
        } else {
            return;
        }
        proxy.getPhysicsBodyId().ifPresent(id -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                return;
            }
            this.velthoric_originalStates.computeIfAbsent(entity.m_19879_(), k -> new VxMountingEntityState()).setFrom(entity);
            manager.getInterpolator().interpolateFrame(store, index, tickDelta, this.velthoric_interpolatedPosition, this.velthoric_interpolatedRotation);
            Quaternionf physRotation = new Quaternionf(this.velthoric_interpolatedRotation.getX(), this.velthoric_interpolatedRotation.getY(), this.velthoric_interpolatedRotation.getZ(), this.velthoric_interpolatedRotation.getW());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            double targetX = this.velthoric_interpolatedPosition.xx() + (double)rideOffset.x;
            double targetY = this.velthoric_interpolatedPosition.yy() + (double)rideOffset.y;
            double targetZ = this.velthoric_interpolatedPosition.zz() + (double)rideOffset.z;
            entity.m_6034_(targetX, targetY, targetZ);
            entity.f_19854_ = targetX;
            entity.f_19855_ = targetY;
            entity.f_19856_ = targetZ;
            entity.f_19790_ = targetX;
            entity.f_19791_ = targetY;
            entity.f_19792_ = targetZ;
        });
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.AFTER)})
    private void velthoric_postRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.forEach((id, state) -> {
            Entity entity = clientWorld.m_6815_(id.intValue());
            if (entity != null) {
                state.applyTo(entity);
            }
        });
        this.velthoric_originalStates.clear();
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;)V")})
    private void velthoric_setupCameraWithPhysicsBody(LevelRenderer instance, PoseStack poseStack, Vec3 cameraPos, Matrix4f projectionMatrix, Operation<Void> original, float partialTicks, long finishTimeNano, PoseStack matrixStack) {
        Entity entity;
        LocalPlayer player = this.f_109059_.f_91074_;
        if (player == null || !((entity = player.m_20202_()) instanceof VxMountingEntity)) {
            original.call(new Object[]{instance, matrixStack, cameraPos, projectionMatrix});
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)entity;
        proxy.getPhysicsBodyId().ifPresentOrElse(id -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                original.call(new Object[]{instance, matrixStack, cameraPos, projectionMatrix});
                return;
            }
            manager.getInterpolator().interpolateRotation(store, index, partialTicks, this.velthoric_interpolatedRotation);
            Quaternionf physRotation = new Quaternionf(this.velthoric_interpolatedRotation.getX(), this.velthoric_interpolatedRotation.getY(), this.velthoric_interpolatedRotation.getZ(), this.velthoric_interpolatedRotation.getW());
            Quaternionf invPhysRotation = new Quaternionf((Quaterniondc)new Quaterniond((Quaternionfc)physRotation).conjugate());
            matrixStack.m_252781_(invPhysRotation);
            Matrix3f matrix3f = new Matrix3f((Matrix3fc)matrixStack.m_85850_().m_252943_());
            matrix3f.invert();
            RenderSystem.setInverseViewRotationMatrix((Matrix3f)matrix3f);
            double fov = this.m_109141_(this.f_109054_, partialTicks, true);
            Matrix4f newProjectionMatrix = this.m_253088_(Math.max(fov, (double)((Integer)this.f_109059_.f_91066_.m_231837_().m_231551_()).intValue()));
            original.call(new Object[]{instance, matrixStack, this.f_109054_.m_90583_(), newProjectionMatrix});
        }, () -> original.call(new Object[]{instance, matrixStack, cameraPos, projectionMatrix}));
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;")})
    private EntityHitResult velthoric_pickEntityWithOBB(Entity shooter, Vec3 start, Vec3 end, AABB searchBox, Predicate<Entity> filter, double maxDistanceSq, Operation<EntityHitResult> original) {
        Predicate<Entity> vanillaFilter = filter.and(entity -> !(entity.m_20202_() instanceof VxMountingEntity));
        EntityHitResult vanillaResult = (EntityHitResult)original.call(new Object[]{shooter, start, end, searchBox, vanillaFilter, maxDistanceSq});
        double closestHitDistSq = vanillaResult != null ? start.m_82557_(vanillaResult.m_82450_()) : maxDistanceSq;
        EntityHitResult bestOverallResult = vanillaResult;
        List potentialTargets = this.f_109059_.f_91073_.m_6249_(shooter, searchBox, filter);
        float partialTicks = this.f_109059_.m_91296_();
        for (Entity potentialTarget : potentialTargets) {
            double distSq;
            VxMountingEntity proxy;
            Optional physBodyOpt;
            Entity entity2 = potentialTarget.m_20202_();
            if (!(entity2 instanceof VxMountingEntity) || !(physBodyOpt = (proxy = (VxMountingEntity)entity2).getPhysicsBodyId().flatMap(id -> Optional.ofNullable(VxClientBodyManager.getInstance().getBody((UUID)id)))).isPresent() || !((VxBody)physBodyOpt.get()).isInitialized()) continue;
            VxBody physBody = (VxBody)physBodyOpt.get();
            VxTransform physTransform = this.velthoric_getPhysicsBodyTransform(physBody, partialTicks);
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physTransform.getRotation(new Quaternionf()).transform(rideOffset);
            physTransform.getTranslation().addInPlace(rideOffset.x(), rideOffset.y(), rideOffset.z());
            AABB targetAABB = potentialTarget.m_20191_().m_82400_((double)potentialTarget.m_6143_());
            AABB localEntityAABB = targetAABB.m_82386_(-potentialTarget.m_20185_(), -potentialTarget.m_20186_(), -potentialTarget.m_20189_());
            VxOBB obb = new VxOBB(physTransform, localEntityAABB);
            Optional<Vec3> hitPos = obb.clip(start, end);
            if (!hitPos.isPresent() || !((distSq = start.m_82557_(hitPos.get())) < closestHitDistSq)) continue;
            closestHitDistSq = distSq;
            bestOverallResult = new EntityHitResult(potentialTarget, hitPos.get());
        }
        return bestOverallResult;
    }

    @Unique
    private VxTransform velthoric_getPhysicsBodyTransform(VxBody clientBody, float partialTicks) {
        VxTransform transform = new VxTransform();
        VxClientBodyManager.getInstance().getInterpolator().interpolateFrame(VxClientBodyManager.getInstance().getStore(), clientBody.getDataStoreIndex(), partialTicks, this.velthoric_interpolatedPosition, this.velthoric_interpolatedRotation);
        transform.getTranslation().set(this.velthoric_interpolatedPosition);
        transform.getRotation().set(this.velthoric_interpolatedRotation);
        return transform;
    }
}

