/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client.renderer;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;

public class VxDebugRenderer {
    private final VxRenderState renderState = new VxRenderState();
    private final RVec3 interpolatedPosition = new RVec3();
    private final Quat interpolatedRotation = new Quat();

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, VxClientBodyManager manager, float partialTicks) {
        this.renderSeatHitboxes(poseStack, bufferSource, manager, partialTicks);
    }

    private void renderSeatHitboxes(PoseStack poseStack, MultiBufferSource bufferSource, VxClientBodyManager manager, float partialTicks) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        VxClientMountingManager ridingManager = VxClientMountingManager.INSTANCE;
        for (VxBody body : manager.getAllBodies()) {
            if (!body.isInitialized()) continue;
            body.calculateRenderState(partialTicks, this.renderState, this.interpolatedPosition, this.interpolatedRotation);
            for (VxSeat seat : ridingManager.getSeats(body.getPhysicsId())) {
                VxOBB obb = seat.getGlobalOBB(this.renderState.transform);
                if (seat.isDriverSeat()) {
                    this.drawOBB(vertexConsumer, poseStack, obb, 1.0f, 0.0f, 0.0f, 1.0f);
                    continue;
                }
                this.drawOBB(vertexConsumer, poseStack, obb, 0.2f, 0.6f, 1.0f, 1.0f);
            }
        }
    }

    private void drawOBB(VertexConsumer consumer, PoseStack poseStack, VxOBB obb, float r, float g, float b, float a) {
        Vec3[] corners = obb.getCorners();
        VxDebugRenderer.drawLine(consumer, poseStack, corners[0], corners[1], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[1], corners[5], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[5], corners[4], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[4], corners[0], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[3], corners[2], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[2], corners[6], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[6], corners[7], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[7], corners[3], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[0], corners[3], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[1], corners[2], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[4], corners[7], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[5], corners[6], r, g, b, a);
    }

    private static void drawLine(VertexConsumer consumer, PoseStack poseStack, Vec3 p1, Vec3 p2, float r, float g, float b, float a) {
        PoseStack.Pose last = poseStack.m_85850_();
        consumer.m_252986_(last.m_252922_(), (float)p1.f_82479_, (float)p1.f_82480_, (float)p1.f_82481_).m_85950_(r, g, b, a).m_252939_(last.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(last.m_252922_(), (float)p2.f_82479_, (float)p2.f_82480_, (float)p2.f_82481_).m_85950_(r, g, b, a).m_252939_(last.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

