/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;

public class S2CSynchronizedDataBatchPacket {
    private final Map<UUID, byte[]> dataUpdates;

    public S2CSynchronizedDataBatchPacket(Map<UUID, byte[]> dataUpdates) {
        this.dataUpdates = dataUpdates;
    }

    public S2CSynchronizedDataBatchPacket(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        this.dataUpdates = new Object2ObjectArrayMap(size);
        for (int i = 0; i < size; ++i) {
            UUID id = buf.m_130259_();
            byte[] data = buf.m_130052_();
            this.dataUpdates.put(id, data);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.dataUpdates.size());
        for (Map.Entry<UUID, byte[]> entry : this.dataUpdates.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.m_130087_(entry.getValue());
        }
    }

    public static void handle(S2CSynchronizedDataBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            for (Map.Entry<UUID, byte[]> entry : msg.dataUpdates.entrySet()) {
                manager.updateSynchronizedData(entry.getKey(), Unpooled.wrappedBuffer((byte[])entry.getValue()));
            }
        });
    }
}

