/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.persistence;

import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.persistence.VxSerializedBodyData;
import net.xmx.velthoric.physics.body.type.VxBody;
import org.jetbrains.annotations.Nullable;

public final class VxBodyCodec {
    private VxBodyCodec() {
    }

    public static void serialize(VxBody body, int index, VxBodyDataStore dataStore, VxByteBuf buf) {
        buf.m_130077_(body.getPhysicsId());
        buf.m_130070_(body.getType().getTypeId().toString());
        buf.writeDouble(dataStore.posX[index]);
        buf.writeDouble(dataStore.posY[index]);
        buf.writeDouble(dataStore.posZ[index]);
        buf.writeFloat(dataStore.rotX[index]);
        buf.writeFloat(dataStore.rotY[index]);
        buf.writeFloat(dataStore.rotZ[index]);
        buf.writeFloat(dataStore.rotW[index]);
        buf.writeFloat(dataStore.velX[index]);
        buf.writeFloat(dataStore.velY[index]);
        buf.writeFloat(dataStore.velZ[index]);
        buf.writeFloat(dataStore.angVelX[index]);
        buf.writeFloat(dataStore.angVelY[index]);
        buf.writeFloat(dataStore.angVelZ[index]);
        buf.writeByte(dataStore.motionType[index] != null ? dataStore.motionType[index].ordinal() : EMotionType.Static.ordinal());
        body.writePersistenceData(buf);
    }

    @Nullable
    public static VxSerializedBodyData deserialize(VxByteBuf buf) {
        try {
            UUID id = buf.m_130259_();
            ResourceLocation typeId = new ResourceLocation(buf.m_130277_());
            VxTransform transform = new VxTransform();
            transform.fromBuffer(buf);
            Vec3 linearVelocity = new Vec3(buf.readFloat(), buf.readFloat(), buf.readFloat());
            Vec3 angularVelocity = new Vec3(buf.readFloat(), buf.readFloat(), buf.readFloat());
            EMotionType motionType = EMotionType.values()[buf.readByte()];
            if (!linearVelocity.isFinite() || linearVelocity.isNan() || !angularVelocity.isFinite() || angularVelocity.isNan()) {
                VxMainClass.LOGGER.warn("Deserialized invalid velocity for body {}. Resetting to zero.", (Object)id);
                linearVelocity.set(0.0f, 0.0f, 0.0f);
                angularVelocity.set(0.0f, 0.0f, 0.0f);
            }
            VxByteBuf persistenceData = new VxByteBuf(buf.readBytes(buf.readableBytes()));
            return new VxSerializedBodyData(typeId, id, transform, linearVelocity, angularVelocity, motionType, persistenceData);
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to deserialize physics body from data", (Throwable)e);
            return null;
        }
    }
}

