/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint;

import com.github.stephengold.joltjni.ConeConstraintSettings;
import com.github.stephengold.joltjni.DistanceConstraintSettings;
import com.github.stephengold.joltjni.FixedConstraintSettings;
import com.github.stephengold.joltjni.GearConstraintSettings;
import com.github.stephengold.joltjni.HingeConstraintSettings;
import com.github.stephengold.joltjni.ObjectStreamOut;
import com.github.stephengold.joltjni.PathConstraintSettings;
import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.PulleyConstraintSettings;
import com.github.stephengold.joltjni.RackAndPinionConstraintSettings;
import com.github.stephengold.joltjni.SixDofConstraintSettings;
import com.github.stephengold.joltjni.SliderConstraintSettings;
import com.github.stephengold.joltjni.SwingTwistConstraintSettings;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.EStreamType;
import com.github.stephengold.joltjni.readonly.ConstJoltPhysicsObject;
import com.github.stephengold.joltjni.std.StringStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class VxConstraint {
    private final UUID constraintId;
    private final UUID body1Id;
    private final UUID body2Id;
    private byte[] settingsData;
    private final EConstraintSubType subType;
    @Nullable
    private transient TwoBodyConstraint joltConstraint;

    public VxConstraint(UUID constraintId, UUID body1Id, UUID body2Id, TwoBodyConstraintSettings settings) {
        this.constraintId = constraintId;
        this.body1Id = body1Id;
        this.body2Id = body2Id;
        this.subType = this.getSubTypeFromSettings(settings);
        this.settingsData = this.serializeSettings(settings);
    }

    public VxConstraint(UUID constraintId, UUID body1Id, UUID body2Id, byte[] settingsData, EConstraintSubType subType) {
        this.constraintId = constraintId;
        this.body1Id = body1Id;
        this.body2Id = body2Id;
        this.settingsData = settingsData;
        this.subType = subType;
    }

    public UUID getConstraintId() {
        return this.constraintId;
    }

    public UUID getBody1Id() {
        return this.body1Id;
    }

    public UUID getBody2Id() {
        return this.body2Id;
    }

    public byte[] getSettingsData() {
        return this.settingsData;
    }

    public EConstraintSubType getSubType() {
        return this.subType;
    }

    @Nullable
    public TwoBodyConstraint getJoltConstraint() {
        return this.joltConstraint;
    }

    public void setJoltConstraint(@Nullable TwoBodyConstraint joltConstraint) {
        this.joltConstraint = joltConstraint;
    }

    public void updateSettingsData(TwoBodyConstraintSettings newSettings) {
        this.settingsData = this.serializeSettings(newSettings);
    }

    private byte[] serializeSettings(TwoBodyConstraintSettings settings) {
        try (StringStream stringStream = new StringStream();){
            if (ObjectStreamOut.sWriteObject(stringStream, EStreamType.Text, (ConstJoltPhysicsObject)settings)) {
                byte[] byArray = stringStream.str().getBytes(StandardCharsets.ISO_8859_1);
                return byArray;
            }
        }
        throw new IllegalStateException("Failed to serialize constraint settings.");
    }

    private EConstraintSubType getSubTypeFromSettings(TwoBodyConstraintSettings settings) {
        if (settings instanceof HingeConstraintSettings) {
            return EConstraintSubType.Hinge;
        }
        if (settings instanceof SixDofConstraintSettings) {
            return EConstraintSubType.SixDof;
        }
        if (settings instanceof ConeConstraintSettings) {
            return EConstraintSubType.Cone;
        }
        if (settings instanceof DistanceConstraintSettings) {
            return EConstraintSubType.Distance;
        }
        if (settings instanceof FixedConstraintSettings) {
            return EConstraintSubType.Fixed;
        }
        if (settings instanceof GearConstraintSettings) {
            return EConstraintSubType.Gear;
        }
        if (settings instanceof PathConstraintSettings) {
            return EConstraintSubType.Path;
        }
        if (settings instanceof PointConstraintSettings) {
            return EConstraintSubType.Point;
        }
        if (settings instanceof PulleyConstraintSettings) {
            return EConstraintSubType.Pulley;
        }
        if (settings instanceof RackAndPinionConstraintSettings) {
            return EConstraintSubType.RackAndPinion;
        }
        if (settings instanceof SliderConstraintSettings) {
            return EConstraintSubType.Slider;
        }
        if (settings instanceof SwingTwistConstraintSettings) {
            return EConstraintSubType.SwingTwist;
        }
        throw new IllegalArgumentException("Unknown or unsupported constraint settings type: " + settings.getClass().getName());
    }
}

