/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.manager.VxMountingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxMountingEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> PHYSICS_OBJECT_ID = SynchedEntityData.m_135353_(VxMountingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> SEAT_ID = SynchedEntityData.m_135353_(VxMountingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public VxMountingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20197_().isEmpty()) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PHYSICS_OBJECT_ID, Optional.empty());
        this.f_19804_.m_135372_(SEAT_ID, Optional.empty());
    }

    public Optional<UUID> getPhysicsBodyId() {
        return (Optional)this.f_19804_.m_135370_(PHYSICS_OBJECT_ID);
    }

    public Optional<UUID> getSeatId() {
        return (Optional)this.f_19804_.m_135370_(SEAT_ID);
    }

    public Vector3f getMountPositionOffset() {
        if (this.m_9236_().m_5776_()) {
            return this.getPhysicsBodyId().flatMap(objId -> this.getSeatId().flatMap(seatId -> VxClientMountingManager.INSTANCE.getSeat((UUID)objId, (UUID)seatId))).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
        }
        Entity entity = this.m_146895_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.m_9236_().m_46472_());
            if (physicsWorld != null) {
                VxMountingManager mountingManager = physicsWorld.getMountingManager();
                return mountingManager.getSeatForPlayer(player).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
            }
        }
        return new Vector3f();
    }

    public void setMountInfo(UUID physicsId, UUID seatId) {
        this.f_19804_.m_135381_(PHYSICS_OBJECT_ID, Optional.of(physicsId));
        this.f_19804_.m_135381_(SEAT_ID, Optional.of(seatId));
    }

    public boolean m_20145_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }
}

