/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.manager;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.init.registry.EntityRegistry;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.VxMountable;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.input.VxMountInput;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxMountingManager {
    private final VxPhysicsWorld world;
    private final Object2ObjectMap<UUID, Map<UUID, VxSeat>> bodyToSeatsMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, UUID> playerToPhysicsIdMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, Map<UUID, ServerPlayer>> bodyToRidersMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, VxSeat> playerToSeatMap = new Object2ObjectOpenHashMap();

    public VxMountingManager(VxPhysicsWorld world) {
        this.world = world;
    }

    public void onBodyAdded(VxBody body) {
        VxMountable mountable;
        List<VxSeat> seats;
        if (body instanceof VxMountable && (seats = (mountable = (VxMountable)((Object)body)).defineSeats()) != null) {
            for (VxSeat seat : seats) {
                this.addSeat(body.getPhysicsId(), seat);
            }
        }
    }

    public void onBodyRemoved(VxBody body) {
        if (body instanceof VxMountable) {
            this.bodyToSeatsMap.remove((Object)body.getPhysicsId());
        }
    }

    public void addSeat(UUID physicsId, VxSeat seat) {
        ((Map)this.bodyToSeatsMap.computeIfAbsent((Object)physicsId, k -> new ConcurrentHashMap())).put(seat.getId(), seat);
    }

    public void removeSeat(UUID physicsId, UUID seatId) {
        Map seats = (Map)this.bodyToSeatsMap.get((Object)physicsId);
        if (seats != null) {
            seats.remove(seatId);
            if (seats.isEmpty()) {
                this.bodyToSeatsMap.remove((Object)physicsId);
            }
        }
    }

    public void requestMounting(ServerPlayer player, UUID physicsId, UUID seatId) {
        VxBody body = this.world.getBodyManager().getVxBody(physicsId);
        if (!(body instanceof VxMountable)) {
            VxMainClass.LOGGER.warn("Player {} requested to mount non-mountable body {}", (Object)player.m_7755_().getString(), (Object)physicsId);
            return;
        }
        VxMountable mountable = (VxMountable)((Object)body);
        Optional<VxSeat> seatOpt = this.getSeat(physicsId, seatId);
        if (seatOpt.isEmpty()) {
            VxMainClass.LOGGER.warn("Player {} requested to mount non-existent seat '{}' on body {}", (Object)player.m_7755_().getString(), (Object)seatId, (Object)physicsId);
            return;
        }
        VxSeat seat = seatOpt.get();
        double reachDistance = player.m_7500_() ? 5.0 : 4.5;
        double distanceSq = player.m_146892_().m_82531_((double)body.getTransform().getTranslation().x(), (double)body.getTransform().getTranslation().y(), (double)body.getTransform().getTranslation().z());
        if (distanceSq > reachDistance * reachDistance) {
            VxMainClass.LOGGER.warn("Player {} is too far to mount body {} (distSq: {}, reach: {})", (Object)player.m_7755_().getString(), (Object)physicsId, (Object)distanceSq, (Object)reachDistance);
            return;
        }
        this.startMounting(player, mountable, seat);
    }

    public void startMounting(ServerPlayer player, VxMountable mountable, VxSeat seat) {
        if (player.m_9236_().m_5776_() || this.isMounting(player) || this.isSeatOccupied(mountable.getPhysicsId(), seat)) {
            return;
        }
        VxMountingEntity proxy = new VxMountingEntity((EntityType)EntityRegistry.MOUNTING_ENTITY.get(), player.m_9236_());
        proxy.setMountInfo(mountable.getPhysicsId(), seat.getId());
        VxTransform initialTransform = mountable.getTransform();
        RVec3 initialPos = initialTransform.getTranslation();
        Quat initialRot = initialTransform.getRotation();
        Quaternionf initialQuat = new Quaternionf(initialRot.getX(), initialRot.getY(), initialRot.getZ(), initialRot.getW());
        Vector3f worldOffset = new Vector3f((Vector3fc)seat.getRiderOffset());
        initialQuat.transform(worldOffset);
        double finalX = initialPos.x() + worldOffset.x();
        double finalY = initialPos.y() + worldOffset.y();
        double finalZ = initialPos.z() + worldOffset.z();
        Vector3f eulerAngles = new Vector3f();
        initialQuat.getEulerAnglesXYZ(eulerAngles);
        proxy.m_6034_(finalX, finalY, finalZ);
        proxy.m_146922_((float)Math.toDegrees(eulerAngles.y));
        this.world.getLevel().m_7967_((Entity)proxy);
        player.m_7998_((Entity)proxy, true);
        ((Map)this.bodyToRidersMap.computeIfAbsent((Object)mountable.getPhysicsId(), k -> Maps.newHashMap())).put(player.m_20148_(), player);
        this.playerToPhysicsIdMap.put((Object)player.m_20148_(), (Object)mountable.getPhysicsId());
        this.playerToSeatMap.put((Object)player.m_20148_(), (Object)seat);
        mountable.onStartMounting(player, seat);
    }

    public void stopMounting(ServerPlayer player) {
        Entity vehicle;
        if (!this.isMounting(player)) {
            return;
        }
        UUID playerUuid = player.m_20148_();
        UUID physicsId = (UUID)this.playerToPhysicsIdMap.remove((Object)playerUuid);
        this.playerToSeatMap.remove((Object)playerUuid);
        if (physicsId != null) {
            this.getMountableForPlayer(player).ifPresent(mountable -> mountable.onStopMounting(player));
            Map riders = (Map)this.bodyToRidersMap.get((Object)physicsId);
            if (riders != null) {
                riders.remove(playerUuid);
                if (riders.isEmpty()) {
                    this.bodyToRidersMap.remove((Object)physicsId);
                }
            }
        }
        if ((vehicle = player.m_20202_()) instanceof VxMountingEntity) {
            player.m_8127_();
            vehicle.m_146870_();
        }
    }

    public void onGameTick() {
        ArrayList<Object> playersToStopMounting = new ArrayList<Object>();
        HashSet objectIds = Sets.newHashSet((Iterable)this.bodyToRidersMap.keySet());
        for (UUID uUID : objectIds) {
            Map riders = (Map)this.bodyToRidersMap.get((Object)uUID);
            if (riders == null) continue;
            VxBody physBody = this.world.getBodyManager().getVxBody(uUID);
            if (physBody == null) {
                playersToStopMounting.addAll(riders.values());
                continue;
            }
            VxTransform trans = physBody.getTransform();
            RVec3 pos = trans.getTranslation();
            Quat rot = trans.getRotation();
            Quaternionf jomlQuat = new Quaternionf(rot.getX(), rot.getY(), rot.getZ(), rot.getW());
            Vector3f eulerAngles = new Vector3f();
            jomlQuat.getEulerAnglesXYZ(eulerAngles);
            float yawDegrees = (float)Math.toDegrees(eulerAngles.y);
            for (ServerPlayer rider : Sets.newHashSet(riders.values())) {
                if (rider.m_213877_() || !rider.m_20159_() || !(rider.m_20202_() instanceof VxMountingEntity)) {
                    playersToStopMounting.add(rider);
                    continue;
                }
                VxSeat seat = (VxSeat)this.playerToSeatMap.get((Object)rider.m_20148_());
                if (seat != null) {
                    Entity vehicle = rider.m_20202_();
                    Vector3f rideOffset = new Vector3f((Vector3fc)seat.getRiderOffset());
                    jomlQuat.transform(rideOffset);
                    double finalX = pos.x() + rideOffset.x();
                    double finalY = pos.y() + rideOffset.y();
                    double finalZ = pos.z() + rideOffset.z();
                    vehicle.m_6034_(finalX, finalY, finalZ);
                    vehicle.m_146922_(yawDegrees);
                    continue;
                }
                playersToStopMounting.add(rider);
            }
        }
        for (ServerPlayer serverPlayer : playersToStopMounting) {
            this.stopMounting(serverPlayer);
        }
    }

    public void handlePlayerInput(ServerPlayer player, VxMountInput input) {
        if (!this.isMounting(player)) {
            return;
        }
        this.getSeatForPlayer(player).ifPresent(seat -> {
            if (seat.isDriverSeat()) {
                this.getMountableForPlayer(player).ifPresent(mountable -> mountable.handleDriverInput(player, input));
            }
        });
    }

    public void onPlayerDisconnect(ServerPlayer player) {
        if (this.isMounting(player)) {
            this.stopMounting(player);
        }
    }

    public boolean isMounting(ServerPlayer player) {
        return this.playerToPhysicsIdMap.containsKey((Object)player.m_20148_());
    }

    public boolean isSeatOccupied(UUID physicsId, VxSeat seat) {
        Map riders = (Map)this.bodyToRidersMap.get((Object)physicsId);
        if (riders == null || riders.isEmpty()) {
            return false;
        }
        for (UUID riderUuid : riders.keySet()) {
            VxSeat occupiedSeat = (VxSeat)this.playerToSeatMap.get((Object)riderUuid);
            if (occupiedSeat == null || !occupiedSeat.getId().equals(seat.getId())) continue;
            return true;
        }
        return false;
    }

    public Optional<VxSeat> getSeat(UUID physicsId, UUID seatId) {
        Map seats = (Map)this.bodyToSeatsMap.get((Object)physicsId);
        return seats != null ? Optional.ofNullable((VxSeat)seats.get(seatId)) : Optional.empty();
    }

    public Collection<VxSeat> getSeats(UUID physicsId) {
        Map seats = (Map)this.bodyToSeatsMap.get((Object)physicsId);
        return seats != null ? seats.values() : Collections.emptyList();
    }

    public Optional<VxSeat> getSeatForPlayer(ServerPlayer player) {
        return Optional.ofNullable((VxSeat)this.playerToSeatMap.get((Object)player.m_20148_()));
    }

    public Optional<VxMountable> getMountableForPlayer(ServerPlayer player) {
        UUID physicsId = (UUID)this.playerToPhysicsIdMap.get((Object)player.m_20148_());
        if (physicsId == null) {
            return Optional.empty();
        }
        VxBody body = this.world.getBodyManager().getVxBody(physicsId);
        if (body instanceof VxMountable) {
            return Optional.of((VxMountable)((Object)body));
        }
        return Optional.empty();
    }

    public Map<UUID, Map<UUID, VxSeat>> getAllSeatsByBody() {
        return Collections.unmodifiableMap(this.bodyToSeatsMap);
    }
}

