/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;

public class VxRegionIndex {
    private final Path indexPath;
    private final ConcurrentHashMap<UUID, VxAbstractRegionStorage.RegionPos> index = new ConcurrentHashMap();
    private final AtomicBoolean dirty = new AtomicBoolean(false);

    public VxRegionIndex(Path storagePath, String indexName) {
        this.indexPath = storagePath.resolve(indexName + ".vxidx");
    }

    public void load() {
        Path tempPath = this.indexPath.resolveSibling(String.valueOf(this.indexPath.getFileName()) + ".tmp");
        try {
            Files.deleteIfExists(tempPath);
        }
        catch (IOException e) {
            VxMainClass.LOGGER.warn("Failed to delete stale temporary index file: {}", (Object)tempPath, (Object)e);
        }
        if (!Files.exists(this.indexPath, new LinkOption[0])) {
            return;
        }
        try {
            byte[] fileBytes = Files.readAllBytes(this.indexPath);
            if (fileBytes.length < 8) {
                VxMainClass.LOGGER.warn("Region index file {} is too small to be valid. Ignoring.", (Object)this.indexPath);
                return;
            }
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])fileBytes));
            long storedChecksum = buffer.readLong();
            byte[] dataBytes = new byte[buffer.readableBytes()];
            buffer.readBytes(dataBytes);
            CRC32 crc = new CRC32();
            crc.update(dataBytes);
            if (storedChecksum != crc.getValue()) {
                VxMainClass.LOGGER.error("Checksum mismatch for region index file {}. The file may be corrupt. Ignoring.", (Object)this.indexPath);
                return;
            }
            FriendlyByteBuf dataBuffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])dataBytes));
            while (dataBuffer.isReadable()) {
                UUID id = dataBuffer.m_130259_();
                int x = dataBuffer.readInt();
                int z = dataBuffer.readInt();
                this.index.put(id, new VxAbstractRegionStorage.RegionPos(x, z));
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to load region index from {}", (Object)this.indexPath, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.dirty.compareAndSet(true, false)) {
            return;
        }
        if (this.index.isEmpty()) {
            try {
                Files.deleteIfExists(this.indexPath);
            }
            catch (IOException e) {
                VxMainClass.LOGGER.error("Failed to delete empty region index file {}", (Object)this.indexPath, (Object)e);
            }
            return;
        }
        Path tempPath = this.indexPath.resolveSibling(String.valueOf(this.indexPath.getFileName()) + ".tmp");
        ByteBuf dataBuf = Unpooled.buffer();
        try {
            FriendlyByteBuf friendlyDataBuf = new FriendlyByteBuf(dataBuf);
            this.index.forEach((id, pos) -> {
                friendlyDataBuf.m_130077_(id);
                friendlyDataBuf.writeInt(pos.x());
                friendlyDataBuf.writeInt(pos.z());
            });
            byte[] dataBytes = new byte[dataBuf.readableBytes()];
            dataBuf.readBytes(dataBytes);
            CRC32 crc = new CRC32();
            crc.update(dataBytes);
            long checksum = crc.getValue();
            ByteBuffer finalBuffer = ByteBuffer.allocate(8 + dataBytes.length);
            finalBuffer.putLong(checksum);
            finalBuffer.put(dataBytes);
            finalBuffer.flip();
            Files.createDirectories(this.indexPath.getParent(), new FileAttribute[0]);
            try (FileChannel channel = FileChannel.open(tempPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                channel.write(finalBuffer);
            }
            Files.move(tempPath, this.indexPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            VxMainClass.LOGGER.error("Failed to save region index to {}", (Object)this.indexPath, (Object)e);
            this.dirty.set(true);
        }
        finally {
            if (dataBuf.refCnt() > 0) {
                dataBuf.release();
            }
        }
    }

    public void put(UUID id, VxAbstractRegionStorage.RegionPos pos) {
        VxAbstractRegionStorage.RegionPos oldPos = this.index.put(id, pos);
        if (!pos.equals(oldPos)) {
            this.dirty.set(true);
        }
    }

    public VxAbstractRegionStorage.RegionPos get(UUID id) {
        return this.index.get(id);
    }

    public void remove(UUID id) {
        if (this.index.remove(id) != null) {
            this.dirty.set(true);
        }
    }
}

