/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.raycasting;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxObjectLayerFilters;
import net.xmx.velthoric.physics.raycasting.VxPhysicsRaycaster;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxRaycaster {
    private VxRaycaster() {
    }

    public static Optional<VxHitResult> raycast(Level level, VxClipContext context) {
        net.minecraft.world.phys.Vec3 from = context.m_45702_();
        net.minecraft.world.phys.Vec3 to = context.m_45693_();
        ArrayList hits = new ArrayList();
        VxRaycaster.raycastMinecraft(level, context).ifPresent(hits::add);
        if (context.isIncludePhysics()) {
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
            double maxDistance = from.m_82554_(to);
            net.minecraft.world.phys.Vec3 direction = to.m_82546_(from).m_82541_();
            RVec3 rayOrigin = new RVec3((float)from.f_82479_, (float)from.f_82480_, (float)from.f_82481_);
            Vec3 rayDirection = new Vec3((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_);
            VxRaycaster.raycastPhysics(physicsWorld, rayOrigin, rayDirection, (float)maxDistance).ifPresent(hits::add);
        }
        return hits.stream().min(Comparator.comparingDouble(hit -> hit.m_82450_().m_82557_(from)));
    }

    public static Optional<VxHitResult> raycastMinecraft(Level level, VxClipContext context) {
        double entityHitSq;
        Predicate<Entity> entityPredicate;
        AABB searchBox;
        EntityHitResult entityHitResult;
        net.minecraft.world.phys.Vec3 from = context.m_45702_();
        net.minecraft.world.phys.Vec3 to = context.m_45693_();
        BlockHitResult blockHitResult = level.m_45547_((ClipContext)context);
        double closestHitSq = blockHitResult.m_6662_() == HitResult.Type.MISS ? Double.MAX_VALUE : blockHitResult.m_82450_().m_82557_(from);
        BlockHitResult finalHit = blockHitResult;
        Entity entity = context.getEntity();
        if (entity != null && (entityHitResult = ProjectileUtil.m_37304_((Level)level, (Entity)entity, (net.minecraft.world.phys.Vec3)from, (net.minecraft.world.phys.Vec3)to, (AABB)(searchBox = new AABB(from, to)), entityPredicate = e -> !e.m_5833_() && e.m_6087_())) != null && (entityHitSq = entityHitResult.m_82450_().m_82557_(from)) < closestHitSq) {
            finalHit = entityHitResult;
        }
        return finalHit.m_6662_() != HitResult.Type.MISS ? Optional.of(new VxHitResult((HitResult)finalHit)) : Optional.empty();
    }

    public static Optional<VxHitResult> raycastPhysics(VxPhysicsWorld physicsWorld, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        Optional<VxPhysicsRaycaster.Result> physicsResult = VxPhysicsRaycaster.raycast(physicsWorld, rayOrigin, rayDirection, maxDistance, VxObjectLayerFilters.IGNORE_TERRAIN);
        return physicsResult.map(hit -> {
            RVec3 hitPointR = hit.hitPoint();
            net.minecraft.world.phys.Vec3 hitPoint = new net.minecraft.world.phys.Vec3(hitPointR.xx(), hitPointR.yy(), hitPointR.zz());
            return new VxHitResult(hitPoint, hit.bodyId(), hit.hitNormal(), hit.hitFraction());
        });
    }
}

