/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain;

import com.github.stephengold.joltjni.RVec3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public final class VxSectionPos {
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_SIZE_SHIFT = 4;
    private final int x;
    private final int y;
    private final int z;

    public VxSectionPos() {
        this(0, 0, 0);
    }

    public VxSectionPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public ChunkPos toChunkPos2D() {
        return new ChunkPos(this.x, this.z);
    }

    public static VxSectionPos fromBlockPos(BlockPos pos) {
        return new VxSectionPos(pos.m_123341_() >> 4, pos.m_123342_() >> 4, pos.m_123343_() >> 4);
    }

    public static VxSectionPos fromRVec3(RVec3 pos) {
        return new VxSectionPos(SectionPos.m_235865_((double)pos.x()), SectionPos.m_235865_((double)pos.y()), SectionPos.m_235865_((double)pos.z()));
    }

    public static VxSectionPos fromWorldSpace(double x, double y, double z) {
        return new VxSectionPos((int)Math.floor(x) >> 4, (int)Math.floor(y) >> 4, (int)Math.floor(z) >> 4);
    }

    public BlockPos getOrigin() {
        return new BlockPos(this.x << 4, this.y << 4, this.z << 4);
    }

    public AABB getAABB() {
        BlockPos origin = this.getOrigin();
        return new AABB(origin, origin.m_7918_(16, 16, 16));
    }

    public boolean isWithinWorldHeight(Level level) {
        int minBlockY = this.y << 4;
        int maxBlockY = minBlockY + 15;
        return maxBlockY >= level.m_141937_() && minBlockY < level.m_151558_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VxSectionPos)) {
            return false;
        }
        VxSectionPos other = (VxSectionPos)o;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return (this.x * 31 + this.y) * 31 + this.z;
    }

    public String toString() {
        return "VxSectionPos[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

