/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.xmx.velthoric.physics.terrain.VxSectionPos;

public record VxChunkSnapshot(List<ShapeInfo> shapes, VxSectionPos pos) {
    public static VxChunkSnapshot snapshotFromChunk(Level level, LevelChunk chunk, VxSectionPos pos) {
        int sectionIndex = level.m_151566_(pos.y());
        if (sectionIndex < 0 || sectionIndex >= chunk.m_7103_().length) {
            return new VxChunkSnapshot(Collections.emptyList(), pos);
        }
        LevelChunkSection section = chunk.m_7103_()[sectionIndex];
        if (section == null || section.m_188008_()) {
            return new VxChunkSnapshot(Collections.emptyList(), pos);
        }
        ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
        BlockPos origin = pos.getOrigin();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos currentLocalPos = new BlockPos(x, y, z);
                    BlockPos currentWorldPos = origin.m_121955_((Vec3i)currentLocalPos);
                    BlockState blockState = section.m_62982_(x, y, z);
                    if (blockState.m_60795_() || blockState.m_60812_((BlockGetter)level, currentWorldPos).m_83281_()) continue;
                    shapeInfos.add(new ShapeInfo(blockState, currentLocalPos));
                }
            }
        }
        return new VxChunkSnapshot(shapeInfos, pos);
    }

    public record ShapeInfo(BlockState state, BlockPos localPos) {
    }
}

