/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.generation;

import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.StaticCompoundShapeSettings;
import com.github.stephengold.joltjni.Vec3;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.terrain.cache.VxTerrainShapeCache;
import net.xmx.velthoric.physics.terrain.generation.VxChunkSnapshot;

public final class VxTerrainGenerator
implements AutoCloseable {
    private final VxTerrainShapeCache shapeCache;
    private final Map<Vec3, BoxShapeSettings> boxSettingsCache;
    private static final int BOX_SETTINGS_CACHE_CAPACITY = 256;
    private static final ThreadLocal<Vec3> tempVec3Key = ThreadLocal.withInitial(Vec3::new);

    public VxTerrainGenerator(VxTerrainShapeCache shapeCache) {
        this.shapeCache = shapeCache;
        this.boxSettingsCache = new LinkedHashMap<Vec3, BoxShapeSettings>(256, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Vec3, BoxShapeSettings> eldest) {
                boolean shouldRemove;
                boolean bl = shouldRemove = this.size() > 256;
                if (shouldRemove && eldest.getValue() != null) {
                    eldest.getValue().close();
                }
                return shouldRemove;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapeRefC generateShape(ServerLevel level, VxChunkSnapshot snapshot) {
        int contentHash = snapshot.hashCode();
        ShapeRefC cachedShape = this.shapeCache.get(contentHash);
        if (cachedShape != null) {
            return cachedShape;
        }
        if (snapshot.shapes().isEmpty()) {
            return null;
        }
        try (StaticCompoundShapeSettings compoundSettings = new StaticCompoundShapeSettings();){
            ShapeRefC shapeRefC;
            block25: {
                ShapeResult result;
                block23: {
                    ShapeRefC shapeRefC2;
                    block24: {
                        boolean hasShapes = false;
                        Vec3 halfExtentsKey = tempVec3Key.get();
                        for (VxChunkSnapshot.ShapeInfo info : snapshot.shapes()) {
                            BlockPos worldPos = snapshot.pos().getOrigin().m_121955_((Vec3i)info.localPos());
                            VoxelShape voxelShape = info.state().m_60812_((BlockGetter)level, worldPos);
                            for (AABB aabb : voxelShape.m_83299_()) {
                                BoxShapeSettings boxSettings;
                                float hx = (float)(aabb.m_82362_() / 2.0);
                                float hy = (float)(aabb.m_82376_() / 2.0);
                                float hz = (float)(aabb.m_82385_() / 2.0);
                                if (hx <= 0.001f || hy <= 0.001f || hz <= 0.001f) continue;
                                halfExtentsKey.set(hx, hy, hz);
                                Map<Vec3, BoxShapeSettings> map = this.boxSettingsCache;
                                synchronized (map) {
                                    boxSettings = this.boxSettingsCache.get(halfExtentsKey);
                                    if (boxSettings == null) {
                                        Vec3 newKey = new Vec3(hx, hy, hz);
                                        boxSettings = new BoxShapeSettings(newKey, 0.0f);
                                        this.boxSettingsCache.put(newKey, boxSettings);
                                    }
                                }
                                float cx = (float)((double)info.localPos().m_123341_() + aabb.f_82288_ + (double)hx);
                                float cy = (float)((double)info.localPos().m_123342_() + aabb.f_82289_ + (double)hy);
                                float cz = (float)((double)info.localPos().m_123343_() + aabb.f_82290_ + (double)hz);
                                compoundSettings.addShape(cx, cy, cz, boxSettings);
                                hasShapes = true;
                            }
                        }
                        if (!hasShapes) {
                            Iterator<VxChunkSnapshot.ShapeInfo> iterator = null;
                            return iterator;
                        }
                        result = compoundSettings.create();
                        try {
                            if (!result.isValid()) break block23;
                            ShapeRefC newShape = result.get();
                            this.shapeCache.put(contentHash, newShape);
                            shapeRefC2 = newShape.getPtr().toRefC();
                            if (result == null) break block24;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return shapeRefC2;
                }
                VxMainClass.LOGGER.error("Failed to create StaticCompoundShape for {}: {}", (Object)snapshot.pos(), (Object)result.getError());
                shapeRefC = null;
                if (result == null) break block25;
                result.close();
            }
            return shapeRefC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Vec3, BoxShapeSettings> map = this.boxSettingsCache;
        synchronized (map) {
            for (BoxShapeSettings settings : this.boxSettingsCache.values()) {
                settings.close();
            }
            this.boxSettingsCache.clear();
        }
    }
}

