/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.storage;

import com.github.stephengold.joltjni.ShapeRefC;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.xmx.velthoric.physics.body.AbstractDataStore;
import net.xmx.velthoric.physics.terrain.VxSectionPos;
import org.jetbrains.annotations.Nullable;

public final class VxChunkDataStore
extends AbstractDataStore {
    private static final int INITIAL_CAPACITY = 4096;
    public static final int UNUSED_BODY_ID = 0;
    private final Map<VxSectionPos, Integer> posToIndex = new HashMap<VxSectionPos, Integer>();
    private final List<VxSectionPos> indexToPos = new ArrayList<VxSectionPos>();
    private final Deque<Integer> freeIndices = new ArrayDeque<Integer>();
    private int count = 0;
    private int capacity = 0;
    public int[] states;
    public int[] bodyIds;
    public ShapeRefC[] shapeRefs;
    public boolean[] isPlaceholder;
    public int[] rebuildVersions;
    public int[] referenceCounts;

    public VxChunkDataStore() {
        this.allocate(4096);
    }

    private void allocate(int newCapacity) {
        this.states = this.grow(this.states, newCapacity);
        this.bodyIds = this.grow(this.bodyIds, newCapacity);
        this.shapeRefs = this.grow(this.shapeRefs, newCapacity);
        this.isPlaceholder = this.grow(this.isPlaceholder, newCapacity);
        this.rebuildVersions = this.grow(this.rebuildVersions, newCapacity);
        this.referenceCounts = this.grow(this.referenceCounts, newCapacity);
        Arrays.fill(this.isPlaceholder, this.count, newCapacity, true);
        this.capacity = newCapacity;
    }

    public synchronized int addChunk(VxSectionPos pos) {
        int n;
        Integer existingIndex = this.posToIndex.get(pos);
        if (existingIndex != null) {
            return existingIndex;
        }
        if (this.count == this.capacity) {
            this.allocate(this.capacity + (this.capacity >> 1));
        }
        if (this.freeIndices.isEmpty()) {
            int n2 = this.count;
            n = n2;
            this.count = n2 + 1;
        } else {
            n = this.freeIndices.pop();
        }
        int index = n;
        this.posToIndex.put(pos, index);
        if (index >= this.indexToPos.size()) {
            this.indexToPos.add(pos);
        } else {
            this.indexToPos.set(index, pos);
        }
        this.resetIndex(index);
        return index;
    }

    @Nullable
    public synchronized Integer removeChunk(VxSectionPos pos) {
        Integer index = this.posToIndex.remove(pos);
        if (index != null) {
            if (this.shapeRefs[index] != null) {
                this.shapeRefs[index].close();
                this.shapeRefs[index.intValue()] = null;
            }
            this.freeIndices.push(index);
            this.indexToPos.set(index, null);
            return index;
        }
        return null;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.count; ++i) {
            if (this.shapeRefs[i] == null) continue;
            this.shapeRefs[i].close();
        }
        this.posToIndex.clear();
        this.indexToPos.clear();
        this.freeIndices.clear();
        this.count = 0;
        this.allocate(4096);
    }

    public void setShape(int index, ShapeRefC shape) {
        if (this.shapeRefs[index] != null && this.shapeRefs[index] != shape) {
            this.shapeRefs[index].close();
        }
        this.shapeRefs[index] = shape;
    }

    @Nullable
    public synchronized Integer getIndexForPos(VxSectionPos pos) {
        return this.posToIndex.get(pos);
    }

    @Nullable
    public synchronized VxSectionPos getPosForIndex(int index) {
        if (index < 0 || index >= this.indexToPos.size()) {
            return null;
        }
        return this.indexToPos.get(index);
    }

    public synchronized Set<VxSectionPos> getManagedPositions() {
        return new HashSet<VxSectionPos>(this.posToIndex.keySet());
    }

    public synchronized Collection<Integer> getActiveIndices() {
        return new ArrayList<Integer>(this.posToIndex.values());
    }

    public synchronized int getChunkCount() {
        return this.count - this.freeIndices.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    private void resetIndex(int index) {
        this.states[index] = 0;
        this.bodyIds[index] = 0;
        this.shapeRefs[index] = null;
        this.isPlaceholder[index] = true;
        this.rebuildVersions[index] = 0;
        this.referenceCounts[index] = 0;
    }
}

