/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CastShapeCollector;
import com.github.stephengold.joltjni.ShapeCastResult;
import java.util.ArrayList;
import java.util.List;

public class AllHitCastShapeCollector
extends CastShapeCollector {
    public AllHitCastShapeCollector() {
        long collectorVa = AllHitCastShapeCollector.createDefault();
        this.setVirtualAddressAsOwner(collectorVa);
    }

    public int countHits() {
        long collectorVa = this.va();
        int result = AllHitCastShapeCollector.countHits(collectorVa);
        return result;
    }

    public ShapeCastResult get(int index) {
        long collectorVa = this.va();
        long hitVa = AllHitCastShapeCollector.getHit(collectorVa, index);
        ShapeCastResult result = new ShapeCastResult(this, hitVa);
        return result;
    }

    public List<ShapeCastResult> getHits() {
        long collectorVa = this.va();
        int numHits = AllHitCastShapeCollector.countHits(collectorVa);
        ArrayList<ShapeCastResult> result = new ArrayList<ShapeCastResult>(numHits);
        for (int i = 0; i < numHits; ++i) {
            long hitVa = AllHitCastShapeCollector.getHit(collectorVa, i);
            result.add(new ShapeCastResult(this, hitVa));
        }
        return result;
    }

    public void sort() {
        long collectorVa = this.va();
        AllHitCastShapeCollector.sort(collectorVa);
    }

    @Override
    public void reset() {
        long collectorVa = this.va();
        AllHitCastShapeCollector.reset(collectorVa);
    }

    private static native int countHits(long var0);

    private static native long createDefault();

    private static native long getHit(long var0, int var2);

    private static native void reset(long var0);

    private static native void sort(long var0);
}

