/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.TransformedShapeCollector;
import com.github.stephengold.joltjni.readonly.ConstTransformedShape;
import java.util.ArrayList;
import java.util.List;

public class AllHitTransformedShapeCollector
extends TransformedShapeCollector {
    public AllHitTransformedShapeCollector() {
        long collectorVa = AllHitTransformedShapeCollector.createDefault();
        this.setVirtualAddressAsOwner(collectorVa);
    }

    public int countHits() {
        long collectorVa = this.va();
        int result = AllHitTransformedShapeCollector.countHits(collectorVa);
        return result;
    }

    public ConstTransformedShape get(int index) {
        long collectorVa = this.va();
        long hitVa = AllHitTransformedShapeCollector.getHit(collectorVa, index);
        TransformedShape result = new TransformedShape(hitVa, true);
        return result;
    }

    public List<ConstTransformedShape> getHits() {
        long collectorVa = this.va();
        int numHits = AllHitTransformedShapeCollector.countHits(collectorVa);
        ArrayList<ConstTransformedShape> result = new ArrayList<ConstTransformedShape>(numHits);
        for (int i = 0; i < numHits; ++i) {
            long hitVa = AllHitTransformedShapeCollector.getHit(collectorVa, i);
            TransformedShape hit = new TransformedShape(hitVa, true);
            result.add(hit);
        }
        return result;
    }

    @Override
    public void reset() {
        long collectorVa = this.va();
        AllHitTransformedShapeCollector.reset(collectorVa);
    }

    private static native int countHits(long var0);

    private static native long createDefault();

    private static native long getHit(long var0, int var2);

    private static native void reset(long var0);
}

