/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CsrFace;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstCollideShapeResult;
import java.nio.FloatBuffer;

public class CollideShapeResult
extends JoltPhysicsObject
implements ConstCollideShapeResult {
    CollideShapeResult(JoltPhysicsObject container, long shapeResultVa) {
        super(container, shapeResultVa);
    }

    public CollideShapeResult(long shapeResultVa) {
        this.setVirtualAddress(shapeResultVa);
    }

    @Override
    public int getBodyId2() {
        long shapeResultVa = this.va();
        int result = CollideShapeResult.getBodyId2(shapeResultVa);
        return result;
    }

    @Override
    public Vec3 getContactPointOn1() {
        long shapeResultVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CollideShapeResult.getContactPointOn1(shapeResultVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getContactPointOn2() {
        long shapeResultVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CollideShapeResult.getContactPointOn2(shapeResultVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getPenetrationAxis() {
        long shapeResultVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CollideShapeResult.getPenetrationAxis(shapeResultVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getPenetrationDepth() {
        long shapeResultVa = this.va();
        float result = CollideShapeResult.getPenetrationDepth(shapeResultVa);
        return result;
    }

    public CsrFace getShape1Face() {
        long shapeResultVa = this.va();
        long faceVa = CollideShapeResult.getShape1Face(shapeResultVa);
        CsrFace result = new CsrFace(this, faceVa);
        return result;
    }

    public CsrFace getShape2Face() {
        long shapeResultVa = this.va();
        long faceVa = CollideShapeResult.getShape2Face(shapeResultVa);
        CsrFace result = new CsrFace(this, faceVa);
        return result;
    }

    @Override
    public int getSubShapeId1() {
        long shapeResultVa = this.va();
        int result = CollideShapeResult.getSubShapeId1(shapeResultVa);
        return result;
    }

    @Override
    public int getSubShapeId2() {
        long shapeResultVa = this.va();
        int result = CollideShapeResult.getSubShapeId2(shapeResultVa);
        return result;
    }

    private static native int getBodyId2(long var0);

    private static native void getContactPointOn1(long var0, FloatBuffer var2);

    private static native void getContactPointOn2(long var0, FloatBuffer var2);

    private static native void getPenetrationAxis(long var0, FloatBuffer var2);

    private static native float getPenetrationDepth(long var0);

    private static native long getShape1Face(long var0);

    private static native long getShape2Face(long var0);

    private static native int getSubShapeId1(long var0);

    private static native int getSubShapeId2(long var0);
}

